/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.api.ICrawlSpaceBlock;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.zeta.module.ZetaModule;

public abstract class HollowFrameBlock
extends QuarkBlock
implements SimpleWaterloggedBlock,
ICrawlSpaceBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHELL = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final byte FLAG_BOTTOM = 1;
    private static final byte FLAG_TOP = 2;
    private static final byte FLAG_NORTH = 4;
    private static final byte FLAG_SOUTH = 8;
    private static final byte FLAG_WEST = 16;
    private static final byte FLAG_EAST = 32;
    private static final VoxelShape[] SHAPES = new VoxelShape[64];

    public HollowFrameBlock(String regname, ZetaModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean bottom(byte shapeCode) {
        return (shapeCode & 1) != 0;
    }

    public static boolean top(byte shapeCode) {
        return (shapeCode & 2) != 0;
    }

    public static boolean north(byte shapeCode) {
        return (shapeCode & 4) != 0;
    }

    public static boolean south(byte shapeCode) {
        return (shapeCode & 8) != 0;
    }

    public static boolean west(byte shapeCode) {
        return (shapeCode & 0x10) != 0;
    }

    public static boolean east(byte shapeCode) {
        return (shapeCode & 0x20) != 0;
    }

    public static boolean hasDirection(byte shapeCode, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> HollowFrameBlock.bottom(shapeCode);
            case Direction.UP -> HollowFrameBlock.top(shapeCode);
            case Direction.NORTH -> HollowFrameBlock.north(shapeCode);
            case Direction.SOUTH -> HollowFrameBlock.south(shapeCode);
            case Direction.WEST -> HollowFrameBlock.west(shapeCode);
            case Direction.EAST -> HollowFrameBlock.east(shapeCode);
        };
    }

    public boolean hasDirection(BlockState state, Direction direction) {
        return HollowFrameBlock.hasDirection(this.getShapeCode(state), direction);
    }

    protected static byte shapeCode(boolean bottom, boolean top, boolean north, boolean south, boolean west, boolean east) {
        byte flag = 0;
        if (bottom) {
            flag = (byte)(flag | 1);
        }
        if (top) {
            flag = (byte)(flag | 2);
        }
        if (north) {
            flag = (byte)(flag | 4);
        }
        if (south) {
            flag = (byte)(flag | 8);
        }
        if (west) {
            flag = (byte)(flag | 0x10);
        }
        if (east) {
            flag = (byte)(flag | 0x20);
        }
        return flag;
    }

    protected static byte shapeCode(BlockState state, BooleanProperty bottom, BooleanProperty top, BooleanProperty north, BooleanProperty south, BooleanProperty west, BooleanProperty east) {
        return HollowFrameBlock.shapeCode((Boolean)state.m_61143_((Property)bottom), (Boolean)state.m_61143_((Property)top), (Boolean)state.m_61143_((Property)north), (Boolean)state.m_61143_((Property)south), (Boolean)state.m_61143_((Property)west), (Boolean)state.m_61143_((Property)east));
    }

    public abstract byte getShapeCode(BlockState var1);

    @Override
    public boolean canCrawl(Level level, BlockState state, BlockPos pos, Direction direction) {
        return this.hasDirection(state, direction.m_122424_());
    }

    public boolean m_49967_() {
        return true;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        return SHAPES[this.getShapeCode(state)];
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        byte code = this.getShapeCode(state);
        if (ctx.m_6226_()) {
            LivingEntity living;
            EntityCollisionContext eCtx;
            Entity entity;
            code = (byte)(code & 0xFFFFFFFD);
            if (ctx instanceof EntityCollisionContext && (entity = (eCtx = (EntityCollisionContext)ctx).m_193113_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_20186_() >= (double)pos.m_123342_() + SHAPE_BOTTOM.m_83297_(Direction.Axis.Y)) {
                code = (byte)(code & 0xFFFFFFFE);
            }
        }
        return SHAPES[code];
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        if (entity.m_20143_() && entity.m_6144_()) {
            return false;
        }
        byte shapeCode = this.getShapeCode(state);
        if (!HollowFrameBlock.bottom(shapeCode) && !HollowFrameBlock.top(shapeCode)) {
            return false;
        }
        Vec3 eyePos = entity.m_146892_();
        double pad = 0.125;
        if (eyePos.f_82479_ > (double)pos.m_123341_() + pad && eyePos.f_82481_ > (double)pos.m_123343_() + pad && eyePos.f_82479_ < (double)(pos.m_123341_() + 1) - pad && eyePos.f_82481_ < (double)(pos.m_123343_() + 1) - pad) {
            return true;
        }
        return super.isLadder(state, level, pos, entity);
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        byte shapeCode = this.getShapeCode(state);
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && HollowFrameBlock.bottom(shapeCode) && HollowFrameBlock.top(shapeCode);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public boolean m_7923_(@Nonnull BlockState p_56967_) {
        return true;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> def) {
        super.m_7926_(def);
        def.m_61104_(new Property[]{WATERLOGGED});
    }

    static {
        for (byte shapeCode = 0; shapeCode < 64; shapeCode = (byte)(shapeCode + 1)) {
            VoxelShape shape = SHELL;
            if (HollowFrameBlock.bottom(shapeCode)) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_BOTTOM, (BooleanOp)BooleanOp.f_82685_);
            }
            if (HollowFrameBlock.top(shapeCode)) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_TOP, (BooleanOp)BooleanOp.f_82685_);
            }
            if (HollowFrameBlock.north(shapeCode)) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH, (BooleanOp)BooleanOp.f_82685_);
            }
            if (HollowFrameBlock.south(shapeCode)) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH, (BooleanOp)BooleanOp.f_82685_);
            }
            if (HollowFrameBlock.west(shapeCode)) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_WEST, (BooleanOp)BooleanOp.f_82685_);
            }
            if (HollowFrameBlock.east(shapeCode)) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SHAPE_EAST, (BooleanOp)BooleanOp.f_82685_);
            }
            HollowFrameBlock.SHAPES[shapeCode] = shape;
        }
    }
}

