/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.automation.block.FeedingTroughBlock;
import vazkii.quark.content.automation.block.be.FeedingTroughBlockEntity;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="automation", hasSubscriptions=true)
public class FeedingTroughModule
extends ZetaModule {
    public static BlockEntityType<FeedingTroughBlockEntity> blockEntityType;
    public static PoiType feedingTroughPoi;
    @Hint
    Block feeding_trough;
    private static final String TAG_CACHE = "quark:feedingTroughCache";
    public static final Predicate<Holder<PoiType>> IS_FEEDER;
    @Config(description="How long, in game ticks, between animals being able to eat from the trough")
    @Config.Min(value=1.0)
    public static int cooldown;
    @Config(description="The maximum amount of animals allowed around the trough's range for an animal to enter love mode")
    public static int maxAnimals;
    @Config(description="The chance (between 0 and 1) for an animal to enter love mode when eating from the trough")
    @Config.Min(value=0.0, exclusive=true)
    @Config.Max(value=1.0)
    public static double loveChance;
    @Config
    public static double range;
    @Config(description="Set to false to make it so animals look for a nearby trough every time they want to eat instead of remembering the last one. Can affect performance if false.")
    public static boolean enableTroughCaching;
    private static final ThreadLocal<Boolean> breedingOccurred;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreed(BabyEntitySpawnEvent event) {
        if (event.getCausedByPlayer() == null && event.getParentA().f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            breedingOccurred.set(true);
        }
    }

    @SubscribeEvent
    public void onOrbSpawn(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ExperienceOrb && breedingOccurred.get().booleanValue()) {
            event.setCanceled(true);
            breedingOccurred.remove();
        }
    }

    public static Player temptWithTroughs(TemptGoal goal, Player found, ServerLevel level) {
        TroughPointer candidate;
        Animal animal;
        if (!ModuleLoader.INSTANCE.isModuleEnabled(FeedingTroughModule.class) || found != null && (goal.f_25935_.test(found.m_21205_()) || goal.f_25935_.test(found.m_21206_()))) {
            return found;
        }
        PathfinderMob pathfinderMob = goal.f_25924_;
        if (!(pathfinderMob instanceof Animal) || !(animal = (Animal)pathfinderMob).m_5957_() || animal.m_146764_() != 0) {
            return found;
        }
        Vec3 position = animal.m_20182_();
        TroughPointer pointer = null;
        boolean cached = false;
        if (enableTroughCaching && (candidate = TroughPointer.fromEntity((Entity)animal, goal)) != null) {
            pointer = candidate;
            cached = true;
        }
        if (!cached) {
            pointer = level.m_8904_().m_217994_(IS_FEEDER, p -> p.m_123331_(new Vec3i(position.f_82479_, position.f_82480_, position.f_82481_)) <= range * range, animal.m_20183_(), (int)range, PoiManager.Occupancy.ANY).map(Pair::getSecond).map(pos -> FeedingTroughModule.getTroughFakePlayer((Level)level, pos, goal)).filter((Predicate<TroughPointer>)Predicates.notNull()).findFirst().orElse(null);
        }
        if (pointer != null && pointer.exists()) {
            Vec3 targetPos;
            BlockPos location = pointer.pos();
            Vec3 eyesPos = goal.f_25924_.m_20182_().m_82520_(0.0, (double)goal.f_25924_.m_20192_(), 0.0);
            BlockHitResult ray = goal.f_25924_.f_19853_.m_45547_(new ClipContext(eyesPos, targetPos = new Vec3((double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_()).m_82520_(0.5, 0.0625, 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)goal.f_25924_));
            if (ray.m_6662_() == HitResult.Type.BLOCK && ray.m_82425_().equals((Object)location)) {
                if (!cached) {
                    pointer.save((Entity)animal);
                }
                return pointer.player();
            }
        }
        if (cached) {
            animal.getPersistentData().m_128473_(TAG_CACHE);
        }
        return found;
    }

    @Nullable
    private static TroughPointer getTroughFakePlayer(Level level, BlockPos pos, TemptGoal goal) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FeedingTroughBlockEntity) {
            FeedingTroughBlockEntity trough = (FeedingTroughBlockEntity)blockEntity;
            return new TroughPointer(pos, trough.getFoodHolder(goal));
        }
        return null;
    }

    @LoadEvent
    public final void register(ZRegister event) {
        this.feeding_trough = new FeedingTroughBlock("feeding_trough", this, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.6f).m_60918_(SoundType.f_56736_));
        blockEntityType = BlockEntityType.Builder.m_155273_(FeedingTroughBlockEntity::new, (Block[])new Block[]{this.feeding_trough}).m_58966_(null);
        Quark.ZETA.registry.register(blockEntityType, "feeding_trough", Registry.f_122907_);
        feedingTroughPoi = new PoiType(FeedingTroughModule.getBlockStates(this.feeding_trough), 1, 32);
        Quark.ZETA.registry.register(feedingTroughPoi, "feeding_trough", Registry.f_122810_);
    }

    private static Set<BlockState> getBlockStates(Block p_218074_) {
        return ImmutableSet.copyOf((Collection)p_218074_.m_49965_().m_61056_());
    }

    static {
        IS_FEEDER = holder -> holder.m_203373_(Registry.f_122870_.m_7981_((Object)feedingTroughPoi));
        cooldown = 30;
        maxAnimals = 32;
        loveChance = 0.333333333;
        range = 10.0;
        enableTroughCaching = true;
        breedingOccurred = ThreadLocal.withInitial(() -> false);
    }

    private record TroughPointer(BlockPos pos, FakePlayer player) {
        public boolean exists() {
            return this.player != null;
        }

        public void save(Entity e) {
            CompoundTag data = e.getPersistentData();
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", this.pos.m_123341_());
            tag.m_128405_("y", this.pos.m_123342_());
            tag.m_128405_("z", this.pos.m_123343_());
            data.m_128365_(FeedingTroughModule.TAG_CACHE, (Tag)tag);
        }

        public static TroughPointer fromEntity(Entity e, TemptGoal goal) {
            CompoundTag data = e.getPersistentData();
            if (!data.m_128425_(FeedingTroughModule.TAG_CACHE, (int)data.m_7060_())) {
                return null;
            }
            CompoundTag tag = data.m_128469_(FeedingTroughModule.TAG_CACHE);
            int x = tag.m_128451_("x");
            int y = tag.m_128451_("y");
            int z = tag.m_128451_("z");
            BlockPos pos = new BlockPos(x, y, z);
            return FeedingTroughModule.getTroughFakePlayer(e.f_19853_, pos, goal);
        }
    }
}

