/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.content.automation.base.RandomizerPowerState;
import vazkii.zeta.module.ZetaModule;

public class RedstoneRandomizerBlock
extends QuarkBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<RandomizerPowerState> POWERED = EnumProperty.m_61587_((String)"powered", RandomizerPowerState.class);

    public RedstoneRandomizerBlock(String regname, ZetaModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(POWERED, (Comparable)((Object)RandomizerPowerState.OFF)));
        RenderLayerHandler.setRenderType(this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public void m_213897_(@Nonnull BlockState state, @Nonnull ServerLevel world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered((Level)world, pos, state))) {
            state = !willBePowered ? (BlockState)state.m_61124_(POWERED, (Comparable)((Object)RandomizerPowerState.OFF)) : (BlockState)state.m_61124_(POWERED, (Comparable)((Object)(rand.m_188499_() ? RandomizerPowerState.LEFT : RandomizerPowerState.RIGHT)));
            world.m_46597_(pos, state);
        }
    }

    protected void updateState(Level world, BlockPos pos, BlockState state) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered(world, pos, state)) && !world.m_183326_().m_183588_(pos, (Object)this)) {
            TickPriority priority = isPowered ? TickPriority.VERY_HIGH : TickPriority.HIGH;
            world.m_186464_(pos, (Block)this, 2, priority);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader world, BlockPos pos) {
        return RedstoneRandomizerBlock.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_());
    }

    protected boolean isPowered(BlockState state) {
        return state.m_61143_(POWERED) != RandomizerPowerState.OFF;
    }

    public int m_6376_(BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return blockState.m_60746_(blockAccess, pos, side);
    }

    public int m_6378_(BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        RandomizerPowerState powerState = (RandomizerPowerState)((Object)blockState.m_61143_(POWERED));
        return switch (powerState) {
            case RandomizerPowerState.RIGHT -> {
                if (((Direction)blockState.m_61143_((Property)FACING)).m_122427_() == side) {
                    yield 15;
                }
                yield 0;
            }
            case RandomizerPowerState.LEFT -> {
                if (((Direction)blockState.m_61143_((Property)FACING)).m_122428_() == side) {
                    yield 15;
                }
                yield 0;
            }
            default -> 0;
        };
    }

    public void m_6861_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (state.m_60710_((LevelReader)world, pos)) {
            this.updateState(world, pos, state);
        } else {
            RedstoneRandomizerBlock.breakAndDrop(this, state, world, pos);
        }
    }

    public static void breakAndDrop(Block block, BlockState state, Level world, BlockPos pos) {
        RedstoneRandomizerBlock.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, null);
        world.m_7471_(pos, false);
        for (Direction direction : Direction.values()) {
            world.m_46672_(pos.m_121945_(direction), block);
        }
    }

    protected boolean shouldBePowered(Level world, BlockPos pos, BlockState state) {
        return this.calculateInputStrength(world, pos, state) > 0;
    }

    protected int calculateInputStrength(Level world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockPos checkPos = pos.m_121945_(face);
        int strength = world.m_46681_(checkPos, face);
        if (strength >= 15) {
            return strength;
        }
        BlockState checkState = world.m_8055_(checkPos);
        return Math.max(strength, checkState.m_60734_() == Blocks.f_50088_ ? (Integer)checkState.m_61143_((Property)RedStoneWireBlock.f_55500_) : 0);
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (this.shouldBePowered(world, pos, state)) {
            world.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        RedstoneRandomizerBlock.notifyNeighbors(this, world, pos, state);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, world, pos, newState, false);
            RedstoneRandomizerBlock.notifyNeighbors(this, world, pos, state);
        }
    }

    public static void notifyNeighbors(Block block, Level world, BlockPos pos, BlockState state) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockPos neighborPos = pos.m_121945_(face.m_122424_());
        if (ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)world.m_8055_(pos), EnumSet.of(face.m_122424_()), (boolean)false).isCanceled()) {
            return;
        }
        world.m_46586_(neighborPos, block, pos);
        world.m_46590_(neighborPos, block, face);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (stateIn.m_61143_(POWERED) != RandomizerPowerState.OFF) {
            double x = (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.2;
            double y = (double)pos.m_123342_() + 0.4 + ((double)rand.m_188501_() - 0.5) * 0.2;
            double z = (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.2;
            worldIn.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

