/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import vazkii.quark.api.ICollateralMover;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.content.automation.module.IronRodModule;
import vazkii.zeta.module.ZetaModule;

public class IronRodBlock
extends EndRodBlock
implements ICollateralMover,
IQuarkBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = () -> true;
    public static final BooleanProperty CONNECTED = BooleanProperty.m_61465_((String)"connected");

    public IronRodBlock(ZetaModule module) {
        super(BlockBehaviour.Properties.m_60941_((Material)Material.f_76279_, (DyeColor)DyeColor.GRAY).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_());
        Quark.ZETA.registry.registerBlock((Block)this, "iron_rod", true);
        CreativeTabHandler.addTab(this, CreativeModeTab.f_40750_);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.module = module;
    }

    @Override
    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    @Override
    public IronRodBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONNECTED});
    }

    @Override
    public boolean isCollateralMover(Level world, BlockPos source, Direction moveDirection, BlockPos pos) {
        return moveDirection == world.m_8055_(pos).m_61143_((Property)f_52588_) && !world.m_8055_(pos.m_121945_(moveDirection)).m_204336_(IronRodModule.ironRodImmuneTag);
    }

    @Override
    public ICollateralMover.MoveResult getCollateralMovement(Level world, BlockPos source, Direction moveDirection, Direction side, BlockPos pos) {
        return side == moveDirection && !world.m_8055_(pos.m_121945_(side)).m_204336_(IronRodModule.ironRodImmuneTag) ? ICollateralMover.MoveResult.BREAK : ICollateralMover.MoveResult.SKIP;
    }

    public void m_214162_(@Nonnull BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
    }
}

