/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ForgeSoundType;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.content.automation.block.be.FeedingTroughBlockEntity;
import vazkii.quark.content.automation.module.FeedingTroughModule;
import vazkii.zeta.module.ZetaModule;

public class FeedingTroughBlock
extends QuarkBlock
implements EntityBlock {
    private static final SoundType WOOD_WITH_PLANT_STEP = new ForgeSoundType(1.0f, 1.0f, () -> SoundEvents.f_12630_, () -> SoundEvents.f_11992_, () -> SoundEvents.f_12635_, () -> SoundEvents.f_12634_, () -> SoundEvents.f_12633_);
    public static BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    public static final VoxelShape CUBOID_SHAPE = FeedingTroughBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape EMPTY_SHAPE = Shapes.m_83113_((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape FULL_SHAPE = Shapes.m_83113_((VoxelShape)CUBOID_SHAPE, (VoxelShape)FeedingTroughBlock.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape ANIMAL_SHAPE = FeedingTroughBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);

    public FeedingTroughBlock(String regname, ZetaModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(regname, module, creativeTab, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Entity entity;
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ecc = (EntityCollisionContext)context;
            v0 = ecc.m_193113_();
        } else {
            v0 = entity = null;
        }
        if (entity instanceof Animal) {
            return ANIMAL_SHAPE;
        }
        return EMPTY_SHAPE;
    }

    @Nonnull
    public VoxelShape m_6079_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return CUBOID_SHAPE;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)FULL) != false ? FULL_SHAPE : EMPTY_SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FULL});
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        if (((Boolean)state.m_61143_((Property)FULL)).booleanValue()) {
            return WOOD_WITH_PLANT_STEP;
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public void m_142072_(Level world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Entity entity, float distance) {
        if (((Boolean)world.m_8055_(pos).m_61143_((Property)FULL)).booleanValue()) {
            entity.m_142535_(distance, 0.2f, DamageSource.f_19315_);
        } else {
            super.m_142072_(world, state, pos, entity, distance);
        }
    }

    public void m_6810_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof FeedingTroughBlockEntity) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((FeedingTroughBlockEntity)tile));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult trace) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider container = this.m_7246_(state, world, pos);
        if (container != null) {
            player.m_5893_(container);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_8133_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }

    @Nullable
    public MenuProvider m_7246_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof MenuProvider ? (MenuProvider)tile : null;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new FeedingTroughBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return FeedingTroughBlock.createTickerHelper(type, FeedingTroughModule.blockEntityType, FeedingTroughBlockEntity::tick);
    }
}

