/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.world.DeferredFeature;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.WeightedGenerator;
import vazkii.quark.base.world.generator.IGenerator;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

public class WorldGenHandler {
    private static final Map<GenerationStep.Decoration, Holder<PlacedFeature>> defers = new HashMap<GenerationStep.Decoration, Holder<PlacedFeature>>();
    private static final Map<GenerationStep.Decoration, SortedSet<WeightedGenerator>> generators = new HashMap<GenerationStep.Decoration, SortedSet<WeightedGenerator>>();

    @LoadEvent
    public static void register(ZRegister event) {
        for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
            DeferredFeature deferredFeature = new DeferredFeature(stage);
            String name = "deferred_feature_" + stage.name().toLowerCase(Locale.ENGLISH);
            Quark.ZETA.registry.register(deferredFeature, name, Registry.f_122838_);
            ConfiguredFeature feature = new ConfiguredFeature((Feature)deferredFeature, (FeatureConfiguration)FeatureConfiguration.f_67737_);
            ResourceLocation resloc = new ResourceLocation("quark", "deferred_feature_" + stage.name().toLowerCase(Locale.ROOT));
            Holder featureHolder = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)resloc, (Object)feature);
            PlacedFeature placed = new PlacedFeature(featureHolder, List.of());
            Holder placedHolder = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)resloc, (Object)placed);
            defers.put(stage, (Holder<PlacedFeature>)placedHolder);
        }
    }

    public static void modifyBiome(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder biomeInfoBuilder) {
        BiomeGenerationSettingsBuilder settings = biomeInfoBuilder.getGenerationSettings();
        for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
            List features = settings.getFeatures(stage);
            features.add(defers.get(stage));
        }
    }

    public static void addGenerator(ZetaModule module, IGenerator generator, GenerationStep.Decoration stage, int weight) {
        WeightedGenerator weighted = new WeightedGenerator(module, generator, weight);
        if (!generators.containsKey(stage)) {
            generators.put(stage, new TreeSet());
        }
        generators.get(stage).add(weighted);
    }

    public static void generateChunk(FeaturePlaceContext<NoneFeatureConfiguration> context, GenerationStep.Decoration stage) {
        WorldGenLevel level = context.m_159774_();
        if (!(level instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion region = (WorldGenRegion)level;
        ChunkGenerator generator = context.m_159775_();
        BlockPos origin = context.m_159777_();
        BlockPos pos = new BlockPos(origin.m_123341_(), 0, origin.m_123343_());
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(region.m_7328_()));
        ChunkPos center = region.m_143488_();
        long seed = random.m_64690_(region.m_7328_(), center.f_45578_ * 16, center.f_45579_ * 16);
        int stageNum = stage.ordinal() * 10000;
        if (generators.containsKey(stage)) {
            SortedSet<WeightedGenerator> set = generators.get(stage);
            for (WeightedGenerator wgen : set) {
                IGenerator gen = wgen.generator();
                if (!wgen.module().enabled || !gen.canGenerate((ServerLevelAccessor)region)) continue;
                if (GeneralConfig.enableWorldgenWatchdog) {
                    int finalStageNum = stageNum;
                    stageNum = WorldGenHandler.watchdogRun(gen, () -> gen.generate(finalStageNum, seed, stage, region, generator, random, pos), 1, TimeUnit.MINUTES);
                    continue;
                }
                stageNum = gen.generate(stageNum, seed, stage, region, generator, random, pos);
            }
        }
    }

    private static int watchdogRun(IGenerator gen, Callable<Integer> run, int time, TimeUnit unit) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Integer> future = exec.submit(run);
        exec.shutdown();
        try {
            return future.get(time, unit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating " + gen, e);
        }
    }

    public static void registerBiomeModifier(IEventBus bus) {
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"quark");
        biomeModifiers.register(bus);
        biomeModifiers.register(QuarkBiomeModifier.RESOURCE.m_135815_(), QuarkBiomeModifier::makeCodec);
    }

    private static class QuarkBiomeModifier
    implements BiomeModifier {
        public static final ResourceLocation RESOURCE = new ResourceLocation("quark", "biome_modifier");
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)RESOURCE, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"quark");

        private QuarkBiomeModifier() {
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                WorldGenHandler.modifyBiome(biome, builder);
                EntitySpawnHandler.modifyBiome(biome, builder);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<QuarkBiomeModifier> makeCodec() {
            return Codec.unit(QuarkBiomeModifier::new);
        }
    }
}

