/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.util;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import vazkii.zeta.block.be.ZetaBlockEntity;

public abstract class SimpleInventoryBlockEntity
extends ZetaBlockEntity
implements WorldlyContainer {
    protected NonNullList<ItemStack> inventorySlots = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);

    public SimpleInventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void readSharedNBT(CompoundTag par1NBTTagCompound) {
        if (!this.needsToSyncInventory()) {
            return;
        }
        ListTag var2 = par1NBTTagCompound.m_128437_("Items", 10);
        this.m_6211_();
        for (int var3 = 0; var3 < var2.size(); ++var3) {
            CompoundTag var4 = var2.m_128728_(var3);
            byte var5 = var4.m_128445_("Slot");
            if (var5 < 0 || var5 >= this.inventorySlots.size()) continue;
            this.inventorySlots.set((int)var5, (Object)ItemStack.m_41712_((CompoundTag)var4));
        }
    }

    @Override
    public void writeSharedNBT(CompoundTag par1NBTTagCompound) {
        if (!this.needsToSyncInventory()) {
            return;
        }
        ListTag var2 = new ListTag();
        for (int var3 = 0; var3 < this.inventorySlots.size(); ++var3) {
            if (((ItemStack)this.inventorySlots.get(var3)).m_41619_()) continue;
            CompoundTag var4 = new CompoundTag();
            var4.m_128344_("Slot", (byte)var3);
            ((ItemStack)this.inventorySlots.get(var3)).m_41739_(var4);
            var2.add((Object)var4);
        }
        par1NBTTagCompound.m_128365_("Items", (Tag)var2);
    }

    protected boolean needsToSyncInventory() {
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventorySlots.get(i);
    }

    @Nonnull
    public ItemStack m_7407_(int i, int j) {
        if (!((ItemStack)this.inventorySlots.get(i)).m_41619_()) {
            if (((ItemStack)this.inventorySlots.get(i)).m_41613_() <= j) {
                ItemStack stackAt = (ItemStack)this.inventorySlots.get(i);
                this.inventorySlots.set(i, (Object)ItemStack.f_41583_);
                this.inventoryChanged(i);
                return stackAt;
            }
            ItemStack stackAt = ((ItemStack)this.inventorySlots.get(i)).m_41620_(j);
            if (((ItemStack)this.inventorySlots.get(i)).m_41613_() == 0) {
                this.inventorySlots.set(i, (Object)ItemStack.f_41583_);
            }
            this.inventoryChanged(i);
            return stackAt;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int i) {
        ItemStack stack = this.m_8020_(i);
        this.m_6836_(i, ItemStack.f_41583_);
        this.inventoryChanged(i);
        return stack;
    }

    public void m_6836_(int i, @Nonnull ItemStack itemstack) {
        this.inventorySlots.set(i, (Object)itemstack);
        this.inventoryChanged(i);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_6542_(@Nonnull Player entityplayer) {
        return this.m_58904_().m_7702_(this.m_58899_()) == this && entityplayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, facing));
        }
        return LazyOptional.empty();
    }

    public boolean m_7013_(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    public void m_5856_(@Nonnull Player player) {
    }

    public void m_5785_(@Nonnull Player player) {
    }

    public void m_6211_() {
        this.inventorySlots = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public void inventoryChanged(int i) {
    }

    public boolean isAutomationEnabled() {
        return true;
    }

    public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return this.isAutomationEnabled();
    }

    public boolean m_7155_(int index, @Nonnull ItemStack itemStackIn, @Nonnull Direction direction) {
        return this.isAutomationEnabled();
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction side) {
        if (this.isAutomationEnabled()) {
            int[] slots = new int[this.m_6643_()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = i;
            }
            return slots;
        }
        return new int[0];
    }
}

