/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.proxy;

import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.Quark;
import vazkii.quark.base.capability.CapabilityHandler;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.RecipeCrawlHandler;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.base.handler.UndergroundBiomeHandler;
import vazkii.quark.base.handler.WoodSetHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.module.LegacyQuarkModuleFinder;
import vazkii.quark.base.module.sync.SyncedFlagHandler;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.recipe.ExclusionRecipe;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZConfigChanged;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaCategory;
import vazkii.zetaimplforge.module.ModFileScanDataModuleFinder;

public class CommonProxy {
    private int lastConfigChange = -11;
    public static boolean jingleTheBells = false;
    private boolean configGuiSaving = false;

    public void start() {
        ForgeRegistries.RECIPE_SERIALIZERS.register("quark:exclusion", (Object)ExclusionRecipe.SERIALIZER);
        Quark.ZETA.loadBus.subscribe(ContributorRewardHandler.class).subscribe(CreativeTabHandler.class).subscribe(QuarkNetwork.class).subscribe(QuarkSounds.class).subscribe(ToolInteractionHandler.class).subscribe(WoodSetHandler.class).subscribe(WorldGenHandler.class).subscribe(FuelHandler.class).subscribe(UndergroundBiomeHandler.class).subscribe(this);
        FMLJavaModLoadingContext.get().getModEventBus().register(EntityAttributeHandler.class);
        MinecraftForge.EVENT_BUS.register(CapabilityHandler.class);
        MinecraftForge.EVENT_BUS.register(ContributorRewardHandler.class);
        MinecraftForge.EVENT_BUS.register(FuelHandler.class);
        MinecraftForge.EVENT_BUS.register(QuarkAdvancementHandler.class);
        MinecraftForge.EVENT_BUS.register(RecipeCrawlHandler.class);
        MinecraftForge.EVENT_BUS.register(ToolInteractionHandler.class);
        Quark.ZETA.loadModules(List.of(new ZetaCategory("automation", Items.f_42451_), new ZetaCategory("building", Items.f_41995_), new ZetaCategory("management", Items.f_42009_), new ZetaCategory("tools", Items.f_42385_), new ZetaCategory("tweaks", Items.f_42715_), new ZetaCategory("world", Items.f_42276_), new ZetaCategory("mobs", Items.f_42630_), new ZetaCategory("client", Items.f_42545_), new ZetaCategory("experimental", Items.f_41996_), new ZetaCategory("oddities", Items.f_42730_, "quarkoddities")), new ModFileScanDataModuleFinder("quark").and(new LegacyQuarkModuleFinder()), GeneralConfig.INSTANCE);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::configChanged);
        bus.addListener(this::registerCapabilities);
        WorldGenHandler.registerBiomeModifier(bus);
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
            jingleTheBells = true;
        }
    }

    @LoadEvent
    public void setup(ZCommonSetup event) {
        this.handleQuarkConfigChange();
    }

    public void configChanged(ModConfigEvent event) {
        if (event.getConfig().getModId().equals("quark") && Quark.ZETA.ticker_SHOULD_NOT_BE_HERE.ticksInGame - this.lastConfigChange > 10 && !this.configGuiSaving) {
            this.lastConfigChange = Quark.ZETA.ticker_SHOULD_NOT_BE_HERE.ticksInGame;
            this.handleQuarkConfigChange();
        }
    }

    public void setConfigGuiSaving(boolean saving) {
        this.configGuiSaving = saving;
        this.lastConfigChange = Quark.ZETA.ticker_SHOULD_NOT_BE_HERE.ticksInGame;
    }

    public void handleQuarkConfigChange() {
        Quark.ZETA.configManager.onReload();
        Quark.ZETA.loadBus.fire(new ZConfigChanged());
        EntitySpawnHandler.refresh();
        SyncedFlagHandler.sendFlagInfoToPlayers();
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityHandler.registerCapabilities(event);
    }

    public InteractionResult clientUseItem(Player player, Level level, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public boolean isClientPlayerHoldingShift() {
        return false;
    }
}

