/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.network;

import java.time.Instant;
import java.util.BitSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import vazkii.quark.base.Quark;
import vazkii.quark.base.network.message.ChangeHotbarMessage;
import vazkii.quark.base.network.message.DoEmoteMessage;
import vazkii.quark.base.network.message.DoubleDoorMessage;
import vazkii.quark.base.network.message.EditSignMessage;
import vazkii.quark.base.network.message.HarvestMessage;
import vazkii.quark.base.network.message.InventoryTransferMessage;
import vazkii.quark.base.network.message.RequestEmoteMessage;
import vazkii.quark.base.network.message.ScrollOnBundleMessage;
import vazkii.quark.base.network.message.SetLockProfileMessage;
import vazkii.quark.base.network.message.ShareItemMessage;
import vazkii.quark.base.network.message.SortInventoryMessage;
import vazkii.quark.base.network.message.UpdateTridentMessage;
import vazkii.quark.base.network.message.experimental.PlaceVariantUpdateMessage;
import vazkii.quark.base.network.message.oddities.HandleBackpackMessage;
import vazkii.quark.base.network.message.oddities.MatrixEnchanterOperationMessage;
import vazkii.quark.base.network.message.oddities.ScrollCrateMessage;
import vazkii.quark.base.network.message.structural.C2SLoginFlag;
import vazkii.quark.base.network.message.structural.C2SUpdateFlag;
import vazkii.quark.base.network.message.structural.HandshakeMessage;
import vazkii.quark.base.network.message.structural.S2CLoginFlag;
import vazkii.quark.base.network.message.structural.S2CUpdateFlag;
import vazkii.quark.content.tweaks.module.LockRotationModule;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.network.IZetaMessage;
import vazkii.zeta.network.ZetaNetworkDirection;
import vazkii.zeta.network.ZetaNetworkHandler;
import vazkii.zetaimplforge.network.ForgeZetaNetworkHandler;

public final class QuarkNetwork {
    private static final int PROTOCOL_VERSION = 2;
    private static ZetaNetworkHandler network;
    @Deprecated(forRemoval=true)
    private static SimpleChannel channel;

    @LoadEvent
    public static void setup(ZCommonSetup event) {
        network = Quark.ZETA.createNetworkHandler("quark", 2);
        channel = ((ForgeZetaNetworkHandler)QuarkNetwork.network).channel;
        network.getSerializer().mapHandlers(Instant.class, (buf, field) -> buf.m_236873_(), (buf, field, instant) -> buf.m_236826_(instant));
        network.getSerializer().mapHandlers(MessageSignature.class, (buf, field) -> new MessageSignature(buf), (buf, field, signature) -> signature.m_241011_(buf));
        network.getSerializer().mapHandlers(LastSeenMessages.Update.class, (buf, field) -> new LastSeenMessages.Update(buf), (buf, field, update) -> update.m_242008_(buf));
        network.getSerializer().mapHandlers(BitSet.class, (buf, field) -> BitSet.valueOf(buf.m_178381_()), (buf, field, bitSet) -> buf.m_130091_(bitSet.toLongArray()));
        network.register(SortInventoryMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(InventoryTransferMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(DoubleDoorMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(HarvestMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(RequestEmoteMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(ChangeHotbarMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(SetLockProfileMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(ShareItemMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(ScrollOnBundleMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.getSerializer().mapHandlers(LockRotationModule.LockProfile.class, LockRotationModule.LockProfile::readProfile, LockRotationModule.LockProfile::writeProfile);
        network.register(HandleBackpackMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(MatrixEnchanterOperationMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(ScrollCrateMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(PlaceVariantUpdateMessage.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        network.register(DoEmoteMessage.class, ZetaNetworkDirection.PLAY_TO_CLIENT);
        network.register(EditSignMessage.class, ZetaNetworkDirection.PLAY_TO_CLIENT);
        network.register(UpdateTridentMessage.class, ZetaNetworkDirection.PLAY_TO_CLIENT);
        network.register(S2CUpdateFlag.class, ZetaNetworkDirection.PLAY_TO_CLIENT);
        network.register(C2SUpdateFlag.class, ZetaNetworkDirection.PLAY_TO_SERVER);
        QuarkNetwork.loginIndexedBuilder(S2CLoginFlag.class, 98, NetworkDirection.LOGIN_TO_CLIENT).decoder(S2CLoginFlag::new).consumerNetworkThread(QuarkNetwork.loginPacketHandler()).buildLoginPacketList(S2CLoginFlag::generateRegistryPackets).add();
        QuarkNetwork.loginIndexedBuilder(C2SLoginFlag.class, 99, NetworkDirection.LOGIN_TO_SERVER).decoder(C2SLoginFlag::new).consumerNetworkThread(QuarkNetwork.loginIndexFirst(QuarkNetwork.loginPacketHandler())).noResponse().add();
    }

    private static <MSG extends HandshakeMessage> SimpleChannel.MessageBuilder<MSG> loginIndexedBuilder(Class<MSG> clazz, int id, NetworkDirection direction) {
        return channel.messageBuilder(clazz, id, direction).loginIndex(HandshakeMessage::getLoginIndex, HandshakeMessage::setLoginIndex).encoder(HandshakeMessage::encode);
    }

    private static <MSG extends HandshakeMessage> BiConsumer<MSG, Supplier<NetworkEvent.Context>> loginPacketHandler() {
        return (msg, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.setPacketHandled(msg.consume(context, (arg_0, arg_1) -> ((SimpleChannel)channel).reply(arg_0, arg_1)));
        };
    }

    private static <MSG extends HandshakeMessage> BiConsumer<MSG, Supplier<NetworkEvent.Context>> loginIndexFirst(BiConsumer<MSG, Supplier<NetworkEvent.Context>> toWrap) {
        return HandshakeHandler.indexFirst((handler, msg, context) -> toWrap.accept(msg, context));
    }

    public static void sendToPlayer(IZetaMessage msg, ServerPlayer player) {
        if (network == null) {
            return;
        }
        network.sendToPlayer(msg, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(IZetaMessage msg) {
        if (network == null || Minecraft.m_91087_().m_91403_() == null) {
            return;
        }
        network.sendToServer(msg);
    }

    public static void sendToPlayers(IZetaMessage msg, Iterable<ServerPlayer> players) {
        if (network == null) {
            return;
        }
        network.sendToPlayers(msg, players);
    }

    public static void sendToAllPlayers(IZetaMessage msg, MinecraftServer server) {
        if (network == null) {
            return;
        }
        network.sendToAllPlayers(msg, server);
    }

    public static Packet<?> toVanillaPacket(IZetaMessage msg, NetworkDirection direction) {
        return channel.toVanillaPacket((Object)msg, direction);
    }
}

