/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.config.FlagCondition;
import vazkii.quark.base.module.config.FlagLootCondition;
import vazkii.quark.base.module.sync.SyncedFlagHandler;
import vazkii.zeta.Zeta;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.recipe.FlagIngredient;
import vazkii.zeta.registry.CraftingExtensionsRegistry;

public final class ConfigFlagManager {
    public final Zeta zeta;
    private final Set<String> allFlags = new HashSet<String>();
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    public final FlagIngredient.Serializer flagIngredientSerializer = new FlagIngredient.Serializer(this);

    public ConfigFlagManager(Zeta zeta) {
        this.zeta = zeta;
        zeta.loadBus.subscribe(this);
    }

    @LoadEvent
    public void onRegister(ZRegister event) {
        CraftingExtensionsRegistry ext = event.getCraftingExtensionsRegistry();
        ext.registerConditionSerializer(new FlagCondition.Serializer(this, new ResourceLocation(this.zeta.modid, "flag")));
        ext.registerConditionSerializer(new FlagCondition.Serializer(this, new ResourceLocation(this.zeta.modid, "advancement_flag"), () -> GeneralConfig.enableQuarkAdvancements));
        FlagLootCondition.FlagSerializer flagSerializer = new FlagLootCondition.FlagSerializer(this);
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation(this.zeta.modid, "flag"), (Object)flagSerializer.selfType);
        ext.registerIngredientSerializer(new ResourceLocation(this.zeta.modid, "flag"), this.flagIngredientSerializer);
        SyncedFlagHandler.setupFlagManager(this);
    }

    public void clear() {
        this.flags.clear();
    }

    public void putFlag(ZetaModule module, String flag, boolean value) {
        this.flags.put(flag, value && module.enabled);
        if (!this.allFlags.contains(flag)) {
            this.allFlags.add(flag);
        }
    }

    public void putModuleFlag(ZetaModule module) {
        this.putFlag(module, module.lowercaseName, true);
    }

    public boolean isValidFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    public boolean getFlag(String flag) {
        Boolean obj = this.flags.get(flag);
        return obj != null && obj != false;
    }

    public Set<String> getAllFlags() {
        return this.allFlags;
    }
}

