/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import vazkii.quark.base.module.LoadModule;
import vazkii.zeta.module.ModuleFinder;
import vazkii.zeta.module.ZetaLoadModuleAnnotationData;

public class LegacyQuarkModuleFinder
implements ModuleFinder {
    private static final Type LOAD_MODULE_TYPE = Type.getType(LoadModule.class);

    @Override
    public Stream<ZetaLoadModuleAnnotationData> get() {
        ModFileScanData scanData = ModList.get().getModFileById("quark").getFile().getScanResult();
        return scanData.getAnnotations().stream().filter(annotationData -> LOAD_MODULE_TYPE.equals((Object)annotationData.annotationType())).sorted(Comparator.comparing(d -> d.getClass().getName())).map(ad -> {
            Class<?> clazz;
            try {
                clazz = Class.forName(ad.clazz().getClassName(), false, LegacyQuarkModuleFinder.class.getClassLoader());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Exception getting QuarkModule (legacy)", e);
            }
            return ZetaLoadModuleAnnotationData.fromForgeThing(clazz, ad.annotationData());
        });
    }
}

