/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler.advancement.mod;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.FilledBucketTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.api.IMutableAdvancement;
import vazkii.quark.base.handler.advancement.AdvancementModifier;
import vazkii.zeta.module.ZetaModule;

public class TacticalFishingModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET = new ResourceLocation("husbandry/tactical_fishing");
    final Set<BucketItem> bucketItems;

    public TacticalFishingModifier(ZetaModule module, Set<BucketItem> buckets) {
        super(module);
        this.bucketItems = buckets;
        Preconditions.checkArgument((!buckets.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        ItemLike[] array = (ItemLike[])this.bucketItems.toArray(ItemLike[]::new);
        Criterion criterion = new Criterion((CriterionTriggerInstance)FilledBucketTrigger.TriggerInstance.m_38793_((ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(array).m_45077_()));
        String name = ForgeRegistries.ITEMS.getKey((Object)array[0].m_5456_()).toString();
        adv.addOrCriterion(name, criterion);
        return true;
    }
}

