/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.event.bus.LoadEvent;

public class RenderLayerHandler {
    public static void setRenderType(Block block, RenderTypeSkeleton skeleton) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Client.setRenderTypeClient(block, skeleton));
    }

    public static void setInherited(Block block, Block parent) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Client.setInheritedClient(block, parent));
    }

    public static enum RenderTypeSkeleton {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }

    public static class Client {
        private static final Map<Block, RenderTypeSkeleton> mapping = new HashMap<Block, RenderTypeSkeleton>();
        private static final Map<Block, Block> inheritances = new HashMap<Block, Block>();
        private static Map<RenderTypeSkeleton, RenderType> renderTypes;

        @LoadEvent
        public static void clientSetup(ZClientSetup event) {
            for (Block b : inheritances.keySet()) {
                Block inherit = inheritances.get(b);
                if (!mapping.containsKey(inherit)) continue;
                mapping.put(b, mapping.get(inherit));
            }
            for (Block b : mapping.keySet()) {
                Client.doSetRenderLayer(b, renderTypes.get((Object)mapping.get(b)));
            }
            inheritances.clear();
            mapping.clear();
        }

        private static void doSetRenderLayer(Block block, RenderType type) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void setRenderTypeClient(Block block, RenderTypeSkeleton skeleton) {
            Client.resolveRenderTypes();
            mapping.put(block, skeleton);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void setInheritedClient(Block block, Block parent) {
            Client.resolveRenderTypes();
            inheritances.put(block, parent);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void resolveRenderTypes() {
            if (renderTypes == null) {
                renderTypes = new HashMap<RenderTypeSkeleton, RenderType>();
                renderTypes.put(RenderTypeSkeleton.SOLID, RenderType.m_110451_());
                renderTypes.put(RenderTypeSkeleton.CUTOUT, RenderType.m_110463_());
                renderTypes.put(RenderTypeSkeleton.CUTOUT_MIPPED, RenderType.m_110457_());
                renderTypes.put(RenderTypeSkeleton.TRANSLUCENT, RenderType.m_110466_());
            }
        }
    }
}

