/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.api.event.RecipeCrawlEvent;
import vazkii.quark.base.Quark;
import vazkii.zeta.util.RegistryUtil;

public class RecipeCrawlHandler {
    private static List<Recipe<?>> recipesToLazyDigest = new ArrayList();
    private static Multimap<Item, ItemStack> recipeDigestion = HashMultimap.create();
    private static Multimap<Item, ItemStack> backwardsDigestion = HashMultimap.create();
    private static final Object mutex = new Object();
    private static boolean needsCrawl = false;
    private static boolean mayCrawl = false;

    @SubscribeEvent
    public static void addListener(AddReloadListenerEvent event) {
        event.addListener((barrier, manager, prepFiller, applyFiller, prepExec, applyExec) -> ((CompletableFuture)CompletableFuture.runAsync(() -> RecipeCrawlHandler.clear(), prepExec).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0))).thenRunAsync(() -> {
            needsCrawl = true;
        }, applyExec));
    }

    @SubscribeEvent
    public static void tagsHaveUpdated(TagsUpdatedEvent event) {
        mayCrawl = true;
    }

    private static void clear() {
        mayCrawl = false;
        MinecraftForge.EVENT_BUS.post((Event)new RecipeCrawlEvent.Reset());
    }

    private static void load(RecipeManager manager) {
        if (!manager.m_44051_().isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)new RecipeCrawlEvent.CrawlStarting());
            recipesToLazyDigest.clear();
            recipeDigestion.clear();
            backwardsDigestion.clear();
            Collection recipes = manager.m_44051_();
            for (Recipe recipe : recipes) {
                try {
                    RecipeCrawlEvent.Visit event;
                    if (recipe == null || recipe.m_7527_() == null || recipe.m_8043_() == null) continue;
                    if (recipe instanceof ShapedRecipe) {
                        ShapedRecipe sr = (ShapedRecipe)recipe;
                        event = new RecipeCrawlEvent.Visit.Shaped(sr);
                    } else if (recipe instanceof ShapelessRecipe) {
                        ShapelessRecipe sr = (ShapelessRecipe)recipe;
                        event = new RecipeCrawlEvent.Visit.Shapeless(sr);
                    } else if (recipe instanceof CustomRecipe) {
                        CustomRecipe cr = (CustomRecipe)recipe;
                        event = new RecipeCrawlEvent.Visit.Custom(cr);
                    } else if (recipe instanceof AbstractCookingRecipe) {
                        AbstractCookingRecipe acr = (AbstractCookingRecipe)recipe;
                        event = new RecipeCrawlEvent.Visit.Cooking(acr);
                    } else {
                        event = new RecipeCrawlEvent.Visit.Misc(recipe);
                    }
                    recipesToLazyDigest.add(recipe);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                }
                catch (Exception e) {
                    Quark.LOG.warn("Failed to scan recipe " + recipe.m_6423_() + ". This should be reported to " + recipe.m_6423_().m_135827_() + "!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent tick) {
        Object object = mutex;
        synchronized (object) {
            if (mayCrawl && needsCrawl) {
                RecipeManager manager = tick.getServer().m_129894_();
                RecipeCrawlHandler.load(manager);
                needsCrawl = false;
            }
            if (!recipesToLazyDigest.isEmpty()) {
                recipeDigestion.clear();
                backwardsDigestion.clear();
                for (Recipe<?> recipe : recipesToLazyDigest) {
                    RecipeCrawlHandler.digest(recipe);
                }
                recipesToLazyDigest.clear();
                MinecraftForge.EVENT_BUS.post((Event)new RecipeCrawlEvent.Digest(recipeDigestion, backwardsDigestion));
            }
        }
    }

    private static void digest(Recipe<?> recipe) {
        ItemStack out = recipe.m_8043_();
        Item outItem = out.m_41720_();
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack inStack : ingredient.m_43908_()) {
                recipeDigestion.put((Object)inStack.m_41720_(), (Object)out);
                backwardsDigestion.put((Object)outItem, (Object)inStack);
            }
        }
    }

    public static void recursivelyFindCraftedItemsFromStrings(@Nullable Collection<String> derivationList, @Nullable Collection<String> whitelist, @Nullable Collection<String> blacklist, Consumer<Item> callback) {
        List<Item> parsedDerivationList = derivationList == null ? null : RegistryUtil.massRegistryGet(derivationList, Registry.f_122827_);
        List<Item> parsedWhitelist = whitelist == null ? null : RegistryUtil.massRegistryGet(whitelist, Registry.f_122827_);
        List<Item> parsedBlacklist = blacklist == null ? null : RegistryUtil.massRegistryGet(blacklist, Registry.f_122827_);
        RecipeCrawlHandler.recursivelyFindCraftedItems(parsedDerivationList, parsedWhitelist, parsedBlacklist, callback);
    }

    public static void recursivelyFindCraftedItems(@Nullable Collection<Item> derivationList, @Nullable Collection<Item> whitelist, @Nullable Collection<Item> blacklist, Consumer<Item> callback) {
        Collection<Object> trueDerivationList = derivationList == null ? Lists.newArrayList() : derivationList;
        Collection<Object> trueWhitelist = whitelist == null ? Lists.newArrayList() : whitelist;
        Collection<Object> trueBlacklist = blacklist == null ? Lists.newArrayList() : blacklist;
        Streams.concat((Stream[])new Stream[]{trueDerivationList.stream(), trueWhitelist.stream()}).forEach(callback);
        HashSet scanned = Sets.newHashSet(trueDerivationList);
        ArrayList toScan = Lists.newArrayList(trueDerivationList);
        while (!toScan.isEmpty()) {
            Item scan = (Item)toScan.remove(0);
            if (!recipeDigestion.containsKey((Object)scan)) continue;
            for (ItemStack digestedStack : recipeDigestion.get((Object)scan)) {
                Item candidate = digestedStack.m_41720_();
                if (scanned.contains(candidate)) continue;
                scanned.add(candidate);
                toScan.add(candidate);
                if (trueBlacklist.contains(candidate)) continue;
                callback.accept(candidate);
            }
        }
    }
}

