/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.Quark;
import vazkii.quark.content.building.block.VerticalSlabBlock;
import vazkii.zeta.event.ZLoadComplete;
import vazkii.zeta.event.bus.LoadEvent;

public class FuelHandler {
    private static final Map<Item, Integer> fuelValues = new HashMap<Item, Integer>();

    public static void addFuel(Item item, int fuel) {
        if (fuel > 0 && item != null && !fuelValues.containsKey(item)) {
            fuelValues.put(item, fuel);
        }
    }

    public static void addFuel(Block block, int fuel) {
        FuelHandler.addFuel(block.m_5456_(), fuel);
    }

    public static void addWood(Block block) {
        String regname = Objects.toString(Quark.ZETA.registry.getRegistryName(block, Registry.f_122824_));
        if (regname.contains("crimson") || regname.contains("warped")) {
            return;
        }
        if (block instanceof VerticalSlabBlock || block instanceof SlabBlock) {
            FuelHandler.addFuel(block, 150);
        } else {
            FuelHandler.addFuel(block, 300);
        }
    }

    @LoadEvent
    public static void addAllWoods(ZLoadComplete event) {
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation regname = Quark.ZETA.registry.getRegistryName(block, Registry.f_122824_);
            if (block == null || !regname.m_135827_().equals("quark") || block.m_49966_().m_60767_() != Material.f_76320_) continue;
            FuelHandler.addWood(block);
        }
    }

    @SubscribeEvent
    public static void getFuel(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (fuelValues.containsKey(item)) {
            event.setBurnTime(fuelValues.get(item).intValue());
        }
    }
}

