/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;

public class CreativeTabHandler {
    private static final List<TabInfo> TAB_INFOS = new ArrayList<TabInfo>();
    private static boolean finalized = false;

    public static void addTab(IQuarkBlock block, @Nullable CreativeModeTab creativeTab, BooleanSupplier isEnabled) {
        if (finalized) {
            try {
                Quark.ZETA.registry.setCreativeTab((Block)block, creativeTab);
            }
            catch (Exception e) {
                Quark.LOG.error("Failed to assign tab to {}", (Object)block, (Object)e);
            }
        }
        if (creativeTab != null) {
            TAB_INFOS.add(new TabInfo(block, creativeTab, isEnabled));
        }
    }

    public static void addTab(IQuarkBlock block, @Nullable CreativeModeTab creativeTab) {
        CreativeTabHandler.addTab(block, creativeTab, block::isEnabled);
    }

    @LoadEvent
    public static void finalizeTabs(ZRegister.Post event) {
        TAB_INFOS.forEach(i -> {
            if (!GeneralConfig.hideDisabledContent || i.enabled.getAsBoolean()) {
                Quark.ZETA.registry.setCreativeTab((Block)i.block, i.tab);
            }
        });
        TAB_INFOS.clear();
        finalized = true;
    }

    private record TabInfo(IQuarkBlock block, CreativeModeTab tab, BooleanSupplier enabled) {
    }
}

