/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.GeneralConfig;

public class NetworkProfilingHandler {
    private static final Map<String, Info> map = new HashMap<String, Info>();

    public static void receive(String name) {
        if (GeneralConfig.enableNetworkProfiling) {
            if (!map.containsKey(name)) {
                map.put(name, new Info());
            }
            map.get(name).add();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void showF3(CustomizeGuiOverlayEvent.DebugText event) {
        if (GeneralConfig.enableNetworkProfiling) {
            event.getLeft().add("");
            for (String s : map.keySet()) {
                Info i = map.get(s);
                int c = i.tick();
                if (c <= 0) continue;
                double cd = (double)c / 5.0;
                ChatFormatting tf = System.currentTimeMillis() - i.getLast() < 100L ? ChatFormatting.RED : ChatFormatting.RESET;
                event.getLeft().add(tf + "PACKET " + s + ": " + cd + "/s (" + i.getCount() + ")");
            }
        }
    }

    private static class Info {
        private static final List<Long> times = new ArrayList<Long>(100);
        int count;
        long last;

        private Info() {
        }

        public void add() {
            this.last = System.currentTimeMillis();
            ++this.count;
            times.add(this.last);
        }

        public int tick() {
            long curr = System.currentTimeMillis();
            long limit = curr - 5000L;
            times.removeIf(t -> t < limit);
            return times.size();
        }

        public long getLast() {
            return this.last;
        }

        public int getCount() {
            return this.count;
        }
    }
}

