/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkPaneBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.zeta.registry.IZetaBlockColorProvider;
import vazkii.zeta.registry.IZetaItemColorProvider;

public class QuarkInheritedPaneBlock
extends QuarkPaneBlock
implements IQuarkBlock,
IZetaBlockColorProvider {
    public final IQuarkBlock parent;

    public QuarkInheritedPaneBlock(IQuarkBlock parent, String name, BlockBehaviour.Properties properties) {
        super(name, parent.getModule(), properties, null);
        this.parent = parent;
        RenderLayerHandler.setInherited((Block)this, parent.getBlock());
    }

    public QuarkInheritedPaneBlock(IQuarkBlock parent, BlockBehaviour.Properties properties) {
        this(parent, IQuarkBlock.inheritQuark(parent, "%s_pane"), properties);
    }

    public QuarkInheritedPaneBlock(IQuarkBlock parent) {
        this(parent, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent.getBlock()));
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.parent.isEnabled();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return this.parent.getBlock().getBeaconColorMultiplier(this.parent.getBlock().m_49966_(), world, pos, beaconPos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        BlockColor blockColor;
        IQuarkBlock iQuarkBlock = this.parent;
        if (iQuarkBlock instanceof IZetaBlockColorProvider) {
            IZetaBlockColorProvider provider = (IZetaBlockColorProvider)((Object)iQuarkBlock);
            blockColor = provider.getBlockColor();
        } else {
            blockColor = null;
        }
        return blockColor;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        ItemColor itemColor;
        IQuarkBlock iQuarkBlock = this.parent;
        if (iQuarkBlock instanceof IZetaItemColorProvider) {
            IZetaItemColorProvider provider = (IZetaItemColorProvider)((Object)iQuarkBlock);
            itemColor = provider.getItemColor();
        } else {
            itemColor = null;
        }
        return itemColor;
    }
}

