/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.zeta.module.ZetaModule;

public class QuarkBlock
extends Block
implements IQuarkBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkBlock(String regname, ZetaModule module, CreativeModeTab creativeTab, BlockBehaviour.Properties properties) {
        super(properties);
        Quark.ZETA.registry.registerBlock(this, regname);
        this.module = module;
        CreativeTabHandler.addTab(this, creativeTab);
        if (module.category.isAddon()) {
            RequiredModTooltipHandler.map(this, module.category.requiredMod);
        }
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public QuarkBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Override
    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> thisType, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == thisType ? ticker : null;
    }

    public static interface Constructor<T extends Block> {
        public T make(String var1, ZetaModule var2, CreativeModeTab var3, BlockBehaviour.Properties var4);
    }
}

