/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.extensions.IForgeBlock;
import vazkii.quark.base.Quark;
import vazkii.zeta.module.ZetaModule;

public interface IQuarkBlock
extends IForgeBlock {
    @Nullable
    public ZetaModule getModule();

    public IQuarkBlock setCondition(BooleanSupplier var1);

    public boolean doesConditionApply();

    default public Block getBlock() {
        return (Block)this;
    }

    default public boolean isEnabled() {
        ZetaModule module = this.getModule();
        return module != null && module.enabled && !module.disabledByOverlap && this.doesConditionApply();
    }

    default public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_61148_().containsKey((Object)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return 0;
        }
        Material material = state.m_60767_();
        if (material == Material.f_76272_ || material == Material.f_76274_) {
            return 60;
        }
        ResourceLocation loc = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        if (loc != null && (loc.m_135815_().endsWith("_log") || loc.m_135815_().endsWith("_wood")) && state.m_60767_().m_76335_()) {
            return 5;
        }
        return state.m_60767_().m_76335_() ? 20 : 0;
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.m_61148_().containsKey((Object)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return 0;
        }
        Material material = state.m_60767_();
        if (material == Material.f_76272_ || material == Material.f_76274_) {
            return 30;
        }
        return state.m_60767_().m_76335_() ? 5 : 0;
    }

    public static String inheritQuark(IQuarkBlock parent, String format) {
        return IQuarkBlock.inherit(parent.getBlock(), format);
    }

    public static String inherit(Block parent, String format) {
        ResourceLocation parentName = Quark.ZETA.registry.getRegistryName(parent, Registry.f_122824_);
        return String.format(String.format("%s:%s", "quark", format), parentName.m_135815_());
    }

    public static String inherit(Block parent, Function<String, String> fun) {
        ResourceLocation parentName = Quark.ZETA.registry.getRegistryName(parent, Registry.f_122824_);
        return String.format(String.format("%s:%s", "quark", fun.apply(parentName.m_135815_())), new Object[0]);
    }
}

