/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.module;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.addons.oddities.block.TinyPotatoBlock;
import vazkii.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import vazkii.quark.addons.oddities.client.model.TinyPotatoModel;
import vazkii.quark.addons.oddities.client.render.be.TinyPotatoRenderer;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.zeta.client.event.ZAddModels;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.client.event.ZModelBakingCompleted;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="oddities", antiOverlap={"botania"}, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class TinyPotatoModule
extends ZetaModule {
    public static BlockEntityType<TinyPotatoBlockEntity> blockEntityType;
    public static QuarkGenericTrigger patPotatoTrigger;
    @Hint
    public static Block tiny_potato;
    @Config(description="Set this to true to use the recipe without the Heart of Diamond, even if the Heart of Diamond is enabled.", flag="tiny_potato_never_uses_heart")
    public static boolean neverUseHeartOfDiamond;

    @LoadEvent
    public final void register(ZRegister event) {
        tiny_potato = new TinyPotatoBlock(this);
        blockEntityType = BlockEntityType.Builder.m_155273_(TinyPotatoBlockEntity::new, (Block[])new Block[]{tiny_potato}).m_58966_(null);
        Quark.ZETA.registry.register(blockEntityType, "tiny_potato", Registry.f_122907_);
        patPotatoTrigger = QuarkAdvancementHandler.registerGenericTrigger("pat_potato");
    }

    @LoadEvent
    @OnlyIn(value=Dist.CLIENT)
    public void modelBake(ZModelBakingCompleted event) {
        ModelResourceLocation tinyPotato = new ModelResourceLocation(new ResourceLocation("quark", "tiny_potato"), "inventory");
        Map<ResourceLocation, BakedModel> map = event.getModels();
        BakedModel originalPotato = map.get(tinyPotato);
        map.put((ResourceLocation)tinyPotato, new TinyPotatoModel(originalPotato));
    }

    @LoadEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerAdditionalModels(ZAddModels event) {
        ResourceManager rm = Minecraft.m_91087_().m_91098_();
        HashSet<String> usedNames = new HashSet<String>();
        this.registerTaters(event, "quark", usedNames, rm);
        this.registerTaters(event, "botania", usedNames, rm);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerTaters(ZAddModels event, String mod, Set<String> usedNames, ResourceManager rm) {
        Map resources = rm.m_214159_("models/tiny_potato", r -> r.m_135815_().endsWith(".json"));
        for (ResourceLocation model : resources.keySet()) {
            String path;
            if (!mod.equals(model.m_135827_()) || "models/tiny_potato/base.json".equals(path = model.m_135815_()) || usedNames.contains(path)) continue;
            usedNames.add(path);
            path = path.substring("models/".length(), path.length() - ".json".length());
            event.register(new ResourceLocation("quark", path));
        }
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        BlockEntityRenderers.m_173590_(blockEntityType, TinyPotatoRenderer::new);
    }

    static {
        neverUseHeartOfDiamond = false;
    }
}

