/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import vazkii.quark.addons.oddities.inventory.CrateMenu;
import vazkii.quark.addons.oddities.module.CrateModule;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.handler.InventoryButtonHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.client.module.ChestSearchingModule;

public class CrateScreen
extends AbstractContainerScreen<CrateMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("quark", "textures/gui/crate.png");
    private int lastScroll;
    private int scrollOffs;
    private boolean scrolling;
    private List<Rect2i> extraAreas;

    public CrateScreen(CrateMenu container, Inventory inv, Component component) {
        super((AbstractContainerMenu)container, inv, component);
        int inventoryRows = 6;
        this.f_97727_ = 114 + inventoryRows * 18;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.extraAreas = Lists.newArrayList((Object[])new Rect2i[]{new Rect2i(i + this.f_97726_, j, 23, 136)});
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    private boolean canScroll() {
        return ((CrateMenu)this.f_97732_).getStackCount() / 9 > 0;
    }

    private float getPxPerScroll() {
        return 95.0f / (float)(((CrateMenu)this.f_97732_).getStackCount() / 9);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        ((CrateMenu)this.f_97732_).scroll(delta < 0.0, true);
        this.lastScroll = this.scrollOffs = Math.round((float)(((CrateMenu)this.f_97732_).scroll / 9) * this.getPxPerScroll());
        return true;
    }

    public boolean m_6375_(double p_98531_, double p_98532_, int p_98533_) {
        if (p_98533_ == 0 && this.insideScrollbar(p_98531_, p_98532_)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.m_6375_(p_98531_, p_98532_, p_98533_);
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int left = this.f_97735_ + 175;
        int top = this.f_97736_ + 18;
        int right = left + 14;
        int bottom = top + 112;
        return mouseX >= (double)left && mouseY >= (double)top && mouseX < (double)right && mouseY < (double)bottom;
    }

    public boolean m_7979_(double mouseX, double mouseY, int p_98537_, double p_98538_, double p_98539_) {
        if (this.scrolling) {
            int top = this.f_97736_ + 18;
            double relative = mouseY - (double)top - 6.0;
            if (relative < 0.0) {
                relative = 0.0;
            } else if (relative > 95.0) {
                relative = 95.0;
            }
            this.scrollOffs = (int)relative;
            float diff = this.scrollOffs - this.lastScroll;
            float pixelsNeeded = this.getPxPerScroll();
            while (Math.abs(diff) >= pixelsNeeded) {
                boolean up = diff > 0.0f;
                ((CrateMenu)this.f_97732_).scroll(up, true);
                this.lastScroll = Math.round((float)(((CrateMenu)this.f_97732_).scroll / 9) * pixelsNeeded);
                diff = this.scrollOffs - this.lastScroll;
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, p_98537_, p_98538_, p_98539_);
    }

    public boolean m_6348_(double p_98622_, double p_98623_, int p_98624_) {
        if (p_98624_ == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(p_98622_, p_98623_, p_98624_);
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_ + 20, this.f_97727_);
        int maxScroll = ((CrateMenu)this.f_97732_).getStackCount() / 9 * 9;
        int u = 232 + (maxScroll == 0 ? 12 : 0);
        int by = j + 18 + this.scrollOffs;
        this.m_93228_(matrixStack, i + this.f_97726_, by, u, 0, 12, 15);
        if (!Quark.ZETA.modules.get(ChestSearchingModule.class).searchBarShown()) {
            String s = ((CrateMenu)this.f_97732_).getTotal() + "/" + CrateModule.maxItems;
            int color = MiscUtil.Client.getGuiTextColor("crate_count");
            this.f_96547_.m_92883_(matrixStack, s, (float)(i + this.f_97726_ - this.f_96547_.m_92895_(s) - 8 - InventoryButtonHandler.getActiveButtons(InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY).size() * 12), (float)(j + 6), color);
        }
    }

    protected void m_7027_(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        int color = MiscUtil.Client.getGuiTextColor("crate_count");
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, color);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, color);
    }
}

