/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.addons.oddities.entity.TotemOfHoldingEntity;
import vazkii.quark.base.QuarkClient;

@OnlyIn(value=Dist.CLIENT)
public class TotemOfHoldingRenderer
extends EntityRenderer<TotemOfHoldingEntity> {
    private static final ModelResourceLocation LOCATION_MODEL = new ModelResourceLocation("quark", "extra/totem_of_holding", "inventory");

    public TotemOfHoldingRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TotemOfHoldingEntity entity, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn) {
        int deathTicks = entity.getDeathTicks();
        boolean dying = entity.isDying();
        float time = (float)QuarkClient.ticker.ticksInGame + partialTicks;
        float scale = !dying ? 1.0f : Math.max(0.0f, 40.0f - ((float)deathTicks + partialTicks)) / 40.0f;
        float rotation = time + (!dying ? 0.0f : ((float)deathTicks + partialTicks) * 5.0f);
        double translation = !dying ? Math.sin((double)time * 0.03) * 0.1 : (double)(((float)deathTicks + partialTicks) / 40.0f * 5.0f);
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        ModelManager modelManager = mc.m_91304_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        matrixStackIn.m_85837_(0.0, translation, 0.0);
        matrixStackIn.m_85841_(scale, scale, scale);
        matrixStackIn.m_85837_(-0.5, 0.0, -0.5);
        dispatcher.m_110937_().m_111067_(matrixStackIn.m_85850_(), bufferIn.m_6299_(Sheets.m_110790_()), null, modelManager.m_119422_(LOCATION_MODEL), 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.f_118083_);
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected int getBlockLightLevel(@Nonnull TotemOfHoldingEntity entityIn, @Nonnull BlockPos position) {
        return 15;
    }

    protected boolean shouldShowName(TotemOfHoldingEntity entity) {
        if (entity.m_8077_()) {
            Minecraft mc = Minecraft.m_91087_();
            return !mc.f_91066_.f_92062_ && mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)mc.f_91077_).m_82443_() == entity;
        }
        return false;
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull TotemOfHoldingEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

