/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageAdditiveMotion;

@Mod.EventBusSubscriber(modid="psi")
public class AdditiveMotionHandler {
    private static final Map<Entity, Vec3> toUpdate = new WeakHashMap<Entity, Vec3>();

    public static void addMotion(Entity entity, double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return;
        }
        if (!entity.f_19853_.f_46443_) {
            Vec3 base = toUpdate.getOrDefault(entity, Vec3.f_82478_);
            toUpdate.put(entity, base.m_82520_(x, y, z));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.LevelTickEvent e) {
        if (e.side.isServer() && e.phase == TickEvent.Phase.END) {
            for (Entity entity : toUpdate.keySet()) {
                Vec3 vec;
                if (entity.f_19864_ || (vec = toUpdate.get(entity)) == null) continue;
                MessageAdditiveMotion motion = new MessageAdditiveMotion(entity.m_19879_(), vec.f_82479_, vec.f_82480_, vec.f_82481_);
                if (entity instanceof ServerPlayer) {
                    MessageRegister.sendToPlayer(motion, (Player)((ServerPlayer)entity));
                } else {
                    entity.m_5997_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                }
                if (!(entity.f_19853_ instanceof ServerLevel)) continue;
                MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)motion);
            }
            toUpdate.clear();
        }
    }
}

