/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;

public final class Spell {
    private static final String TAG_VALID = "validSpell";
    public static final String TAG_SPELL_NAME = "spellName";
    public static final String TAG_UUID_MOST = "uuidMost";
    public static final String TAG_UUID_LEAST = "uuidLeast";
    public static final String TAG_MODS_REQUIRED = "modsRequired";
    public static final String TAG_MOD_NAME = "modName";
    public static final String TAG_MOD_VERSION = "modVersion";
    public final SpellGrid grid = new SpellGrid(this);
    public String name = "";
    public UUID uuid = UUID.randomUUID();

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack ms, MultiBufferSource buffers, int light) {
        this.grid.draw(ms, buffers, light);
    }

    @Nullable
    public static Spell createFromNBT(CompoundTag cmp) {
        if (cmp == null || !cmp.m_128471_(TAG_VALID)) {
            return null;
        }
        Spell spell = new Spell();
        spell.readFromNBT(cmp);
        return spell;
    }

    public void readFromNBT(CompoundTag cmp) {
        this.name = cmp.m_128461_(TAG_SPELL_NAME);
        if (cmp.m_128441_(TAG_UUID_MOST)) {
            long uuidMost = cmp.m_128454_(TAG_UUID_MOST);
            long uuidLeast = cmp.m_128454_(TAG_UUID_LEAST);
            if (this.uuid.getMostSignificantBits() != uuidMost || this.uuid.getLeastSignificantBits() != uuidLeast) {
                this.uuid = new UUID(uuidMost, uuidLeast);
            }
        }
        this.grid.readFromNBT(cmp);
    }

    public Set<String> getPieceNamespaces() {
        Set<String> temp = Collections.newSetFromMap(new HashMap());
        SpellPiece[][] spellPieceArray = this.grid.gridData;
        int n = spellPieceArray.length;
        for (int i = 0; i < n; ++i) {
            SpellPiece[] gridDatum;
            for (SpellPiece spellPiece : gridDatum = spellPieceArray[i]) {
                if (spellPiece == null) continue;
                temp.add(spellPiece.registryKey.m_135827_());
            }
        }
        return temp;
    }

    public void writeToNBT(CompoundTag cmp) {
        cmp.m_128379_(TAG_VALID, true);
        cmp.m_128359_(TAG_SPELL_NAME, this.name);
        ListTag modList = new ListTag();
        for (String namespace : this.getPieceNamespaces()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_(TAG_MOD_NAME, namespace);
            if (ModList.get().getModContainerById(namespace).isPresent()) {
                nbt.m_128359_(TAG_MOD_VERSION, ((ModContainer)ModList.get().getModContainerById(namespace).get()).getModInfo().getVersion().toString());
            }
            modList.add((Object)nbt);
        }
        cmp.m_128365_(TAG_MODS_REQUIRED, (Tag)modList);
        cmp.m_128356_(TAG_UUID_MOST, this.uuid.getMostSignificantBits());
        cmp.m_128356_(TAG_UUID_LEAST, this.uuid.getLeastSignificantBits());
        this.grid.writeToNBT(cmp);
    }

    public Spell copy() {
        CompoundTag cmp = new CompoundTag();
        this.writeToNBT(cmp);
        return Spell.createFromNBT(cmp);
    }
}

