/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import vazkii.psi.api.ClientPsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.DummyMethodHandler;
import vazkii.psi.api.internal.IInternalMethodHandler;
import vazkii.psi.api.material.PsimetalArmorMaterial;
import vazkii.psi.api.material.PsimetalToolMaterial;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.detonator.IDetonationHandler;

public final class PsiAPI {
    public static IInternalMethodHandler internalHandler = new DummyMethodHandler();
    public static Capability<ISpellImmune> SPELL_IMMUNE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpellImmune>(){});
    public static Capability<IDetonationHandler> DETONATION_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDetonationHandler>(){});
    public static Capability<IPsiBarDisplay> PSI_BAR_DISPLAY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPsiBarDisplay>(){});
    public static Capability<ISpellAcceptor> SPELL_ACCEPTOR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISpellAcceptor>(){});
    public static Capability<ICADData> CAD_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICADData>(){});
    public static Capability<ISocketable> SOCKETABLE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISocketable>(){});
    public static final String MOD_ID = "psi";
    public static final ResourceKey<Registry<Class<? extends SpellPiece>>> SPELL_PIECE_REGISTRY_TYPE_KEY = Registry.m_122978_((String)"spell_piece_registry_type_key");
    private static final MappedRegistry<Class<? extends SpellPiece>> spellPieceRegistry = new MappedRegistry(SPELL_PIECE_REGISTRY_TYPE_KEY, Lifecycle.stable(), null);
    private static final Multimap<ResourceLocation, Class<? extends SpellPiece>> advancementGroups = HashMultimap.create();
    private static final Map<Class<? extends SpellPiece>, ResourceLocation> advancementGroupsInverse = new HashMap<Class<? extends SpellPiece>, ResourceLocation>();
    private static final Map<ResourceLocation, Class<? extends SpellPiece>> mainPieceForGroup = new HashMap<ResourceLocation, Class<? extends SpellPiece>>();
    public static final PsimetalArmorMaterial PSIMETAL_ARMOR_MATERIAL = new PsimetalArmorMaterial("psimetal", 18, new int[]{2, 5, 6, 2}, 12, SoundEvents.f_11677_, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(MOD_ID, "psimetal"))}), 0.0f);
    public static final PsimetalToolMaterial PSIMETAL_TOOL_MATERIAL = new PsimetalToolMaterial();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSpellPiece(ResourceLocation resourceLocation, Class<? extends SpellPiece> clazz) {
        MappedRegistry<Class<? extends SpellPiece>> mappedRegistry = spellPieceRegistry;
        synchronized (mappedRegistry) {
            spellPieceRegistry.m_203505_(ResourceKey.m_135785_(SPELL_PIECE_REGISTRY_TYPE_KEY, (ResourceLocation)resourceLocation), clazz, Lifecycle.stable());
        }
    }

    public static void registerSpellPieceAndTexture(ResourceLocation id, Class<? extends SpellPiece> clazz) {
        PsiAPI.registerSpellPiece(id, clazz);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPsiAPI.registerPieceTexture(id, new ResourceLocation(id.m_135827_(), "spell/" + id.m_135815_())));
    }

    public static void addPieceToGroup(Class<? extends SpellPiece> clazz, ResourceLocation resLoc, boolean main) {
        advancementGroups.put((Object)resLoc, clazz);
        advancementGroupsInverse.put(clazz, resLoc);
        if (main) {
            if (mainPieceForGroup.containsKey(resLoc)) {
                LogManager.getLogger((String)MOD_ID).info("Group " + resLoc + " already has a main piece!");
            }
            mainPieceForGroup.put(resLoc, clazz);
        }
    }

    public static ItemStack getPlayerCAD(Player player) {
        if (player == null) {
            return ItemStack.f_41583_;
        }
        ItemStack cad = ItemStack.f_41583_;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stackAt = player.m_150109_().m_8020_(i);
            if (stackAt.m_41619_() || !(stackAt.m_41720_() instanceof ICAD)) continue;
            if (!cad.m_41619_()) {
                return ItemStack.f_41583_;
            }
            cad = stackAt;
        }
        return cad;
    }

    public static int getPlayerCADSlot(Player player) {
        if (player == null) {
            return -1;
        }
        int slot = -1;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stackAt = player.m_150109_().m_8020_(i);
            if (stackAt.m_41619_() || !(stackAt.m_41720_() instanceof ICAD)) continue;
            if (slot != -1) {
                return -1;
            }
            slot = i;
        }
        return slot;
    }

    public static boolean canCADBeUpdated(Player player) {
        if (player == null) {
            return false;
        }
        if (player.f_36096_ == null) {
            return true;
        }
        int cadSlot = PsiAPI.getPlayerCADSlot(player);
        return cadSlot < 9 || cadSlot == 40;
    }

    public static Class<? extends SpellPiece> getSpellPiece(ResourceLocation key) {
        return (Class)spellPieceRegistry.m_7745_(key);
    }

    public static ResourceLocation getSpellPieceKey(Class<? extends SpellPiece> clazz) {
        return spellPieceRegistry.m_7981_(clazz);
    }

    public static Collection<Class<? extends SpellPiece>> getPiecesInAdvancementGroup(ResourceLocation group) {
        return advancementGroups.get((Object)group);
    }

    public static ResourceLocation getGroupForPiece(Class<? extends SpellPiece> piece) {
        return advancementGroupsInverse.get(piece);
    }

    public static Class<? extends SpellPiece> getMainPieceForGroup(ResourceLocation group) {
        return mainPieceForGroup.get(group);
    }

    public static boolean isPieceRegistered(ResourceLocation key) {
        return spellPieceRegistry.m_6566_().contains(key);
    }

    public static Collection<Class<? extends SpellPiece>> getAllRegisteredSpellPieces() {
        return spellPieceRegistry.m_123024_().collect(Collectors.toList());
    }

    public static Collection<ResourceLocation> getAllPieceKeys() {
        return spellPieceRegistry.m_6566_();
    }

    public static MappedRegistry<Class<? extends SpellPiece>> getSpellPieceRegistry() {
        return spellPieceRegistry;
    }
}

