/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellHelpers;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.Psi;

public class PieceTrickPlaySound
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> pitch;
    SpellParam<Number> volume;
    SpellParam<Number> instrument;

    public PieceTrickPlaySound(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.instrument = new ParamNumber("psi.spellparam.instrument", SpellParam.RED, false, false);
        this.addParam(this.instrument);
        this.pitch = new ParamNumber("psi.spellparam.pitch", SpellParam.GREEN, true, false);
        this.addParam(this.pitch);
        this.volume = new ParamNumber("psi.spellparam.volume", SpellParam.YELLOW, true, false);
        this.addParam(this.volume);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        double dVol = SpellHelpers.ensurePositiveOrZero(this, this.volume, 1.0);
        double dPit = SpellHelpers.ensurePositiveOrZero(this, this.pitch, 0.0);
        if (dPit > 24.0) {
            throw new SpellCompilationException("psi.spellerror.pitch", this.x, this.y);
        }
        if (dVol > 1.0) {
            throw new SpellCompilationException("psi.spellerror.volume", this.x, this.y);
        }
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        BlockPos pos = SpellHelpers.getBlockPos(this, context, this.position, true, false);
        double instrumentVal = this.getParamValue(context, this.instrument).doubleValue();
        double volVal = ((Number)this.getParamValueOrDefault(context, this.volume, 1)).doubleValue();
        double pitchVal = ((Number)this.getParamValueOrDefault(context, this.pitch, 0)).doubleValue();
        int instrumentId = Mth.m_14045_((int)((int)instrumentVal), (int)0, (int)(Psi.noteblockSoundEvents.size() - 1));
        float f = (float)Math.pow(2.0, (pitchVal - 12.0) / 12.0);
        context.caster.f_19853_.m_5594_(null, pos, Psi.noteblockSoundEvents.get(instrumentId), SoundSource.RECORDS, (float)volVal, f);
        return null;
    }
}

