/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class ItemExosuitController
extends Item
implements ISocketableController {
    private static final String TAG_SELECTED_CONTROL_SLOT = "selectedControlSlot";

    public ItemExosuitController(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand hand) {
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        if (playerIn.m_6144_()) {
            ItemStack[] stacks;
            if (!worldIn.f_46443_) {
                worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), PsiSoundHandler.compileError, SoundSource.PLAYERS, 0.25f, 1.0f);
            } else {
                playerIn.m_6674_(hand);
            }
            for (ItemStack stack : stacks = this.getControlledStacks(playerIn, itemStackIn)) {
                stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).ifPresent(c -> c.setSelectedSlot(3));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public ItemStack[] getControlledStacks(Player player, ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)player.m_150109_().f_35975_.get(3 - i);
            if (armor.m_41619_() || !ISocketable.isSocketable(armor)) continue;
            stacks.add(armor);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    @Override
    public int getDefaultControlSlot(ItemStack stack) {
        return stack.m_41784_().m_128451_(TAG_SELECTED_CONTROL_SLOT);
    }

    @Override
    public void setSelectedSlot(Player player, ItemStack stack, int controlSlot, int slot) {
        stack.m_41784_().m_128405_(TAG_SELECTED_CONTROL_SLOT, controlSlot);
        ItemStack[] stacks = this.getControlledStacks(player, stack);
        if (controlSlot < stacks.length && !stacks[controlSlot].m_41619_()) {
            stacks[controlSlot].getCapability(PsiAPI.SOCKETABLE_CAPABILITY).ifPresent(cap -> cap.setSelectedSlot(slot));
        }
    }
}

