/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.psi.api.exosuit.ISensorHoldable;

public class SensorRemoveRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<SensorRemoveRecipe> SERIALIZER = new SimpleRecipeSerializer(SensorRemoveRecipe::new);

    public SensorRemoveRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundHoldable = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (!foundHoldable && stack.m_41720_() instanceof ISensorHoldable && !((ISensorHoldable)stack.m_41720_()).getAttachedSensor(stack).m_41619_()) {
                foundHoldable = true;
                continue;
            }
            return false;
        }
        return foundHoldable;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack holdableItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            holdableItem = stack;
        }
        ItemStack copy = holdableItem.m_41777_();
        ISensorHoldable holdable = (ISensorHoldable)holdableItem.m_41720_();
        holdable.attachSensor(copy, ItemStack.f_41583_);
        return copy;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!(item.m_41720_() instanceof ISensorHoldable)) continue;
            list.set(i, (Object)((ISensorHoldable)item.m_41720_()).getAttachedSensor(item));
            break;
        }
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public boolean m_5598_() {
        return true;
    }
}

