/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageLoopcastSync;

@Mod.EventBusSubscriber(modid="psi")
public class LoopcastTrackingHandler {
    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof Player) {
            LoopcastTrackingHandler.syncDataFor((Player)event.getTarget(), (ServerPlayer)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getPlayer(), (ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getPlayer(), (ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getPlayer(), (ServerPlayer)event.getPlayer());
    }

    public static void syncDataFor(Player player, ServerPlayer receiver) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        MessageRegister.sendToPlayer(new MessageLoopcastSync(player.m_142049_(), data.loopcasting, data.loopcastHand), (Player)receiver);
    }

    public static void syncForTrackers(ServerPlayer player) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)player);
        MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageLoopcastSync(player.m_142049_(), data.loopcasting, data.loopcastHand));
    }

    public static void syncForTrackersAndSelf(ServerPlayer playerEntity) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)playerEntity);
        MessageLoopcastSync messageLoopcastSync = new MessageLoopcastSync(playerEntity.m_142049_(), data.loopcasting, data.loopcastHand);
        MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> playerEntity), (Object)messageLoopcastSync);
        MessageRegister.sendToPlayer(messageLoopcastSync, (Player)playerEntity);
    }
}

