/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class BlockProgrammer
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.m_61465_((String)"enabled");
    private static final VoxelShape SHAPE_NORTH;
    private static final VoxelShape SHAPE_SOUTH;
    private static final VoxelShape SHAPE_WEST;
    private static final VoxelShape SHAPE_EAST;

    public BlockProgrammer(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        TileProgrammer programmer = (TileProgrammer)worldIn.m_7702_(pos);
        if (programmer == null) {
            return InteractionResult.PASS;
        }
        InteractionResult result = this.setSpell(worldIn, pos, player, heldItem);
        if (result == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        boolean enabled = programmer.isEnabled();
        if (!enabled || programmer.playerLock.isEmpty()) {
            programmer.playerLock = player.m_7755_().getString();
        }
        if (player instanceof ServerPlayer) {
            VanillaPacketDispatcher.dispatchTEToPlayer(programmer, (ServerPlayer)player);
        }
        if (worldIn.f_46443_) {
            Psi.proxy.openProgrammerGUI(programmer);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult setSpell(Level worldIn, BlockPos pos, Player playerIn, ItemStack heldItem) {
        TileProgrammer programmer = (TileProgrammer)worldIn.m_7702_(pos);
        if (programmer == null) {
            return InteractionResult.FAIL;
        }
        boolean enabled = programmer.isEnabled();
        LazyOptional settable = heldItem.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY);
        if (enabled && !heldItem.m_41619_() && settable.isPresent() && programmer.spell != null && (playerIn.m_6144_() || !((ISpellAcceptor)settable.orElse(null)).requiresSneakForSpellSet())) {
            if (programmer.canCompile()) {
                if (!worldIn.f_46443_) {
                    worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, PsiSoundHandler.bulletCreate, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                programmer.spell.uuid = UUID.randomUUID();
                settable.ifPresent(c -> c.setSpell(playerIn, programmer.spell));
                if (playerIn instanceof ServerPlayer) {
                    VanillaPacketDispatcher.dispatchTEToPlayer(programmer, (ServerPlayer)playerIn);
                }
                return InteractionResult.SUCCESS;
            }
            if (!worldIn.f_46443_) {
                worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, PsiSoundHandler.compileError, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, ENABLED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileProgrammer(pos, state);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof TileProgrammer) {
            TileProgrammer programmer = (TileProgrammer)tile;
            if (programmer.canCompile()) {
                return 2;
            }
            if (programmer.isEnabled()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        return super.m_7246_(state, worldIn, pos);
    }

    static {
        VoxelShape top = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape northMiddle = Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)8.0, (double)16.0);
        VoxelShape southMiddle = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)8.0, (double)2.0);
        VoxelShape zBottom = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)16.0);
        SHAPE_NORTH = Shapes.m_83113_((VoxelShape)top, (VoxelShape)Shapes.m_83113_((VoxelShape)zBottom, (VoxelShape)northMiddle, (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_);
        SHAPE_SOUTH = Shapes.m_83113_((VoxelShape)top, (VoxelShape)Shapes.m_83113_((VoxelShape)zBottom, (VoxelShape)southMiddle, (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_);
        VoxelShape westMiddle = Block.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0);
        VoxelShape eastMiddle = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0);
        VoxelShape xBottom = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)14.0);
        SHAPE_WEST = Shapes.m_83113_((VoxelShape)top, (VoxelShape)Shapes.m_83113_((VoxelShape)xBottom, (VoxelShape)westMiddle, (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_);
        SHAPE_EAST = Shapes.m_83113_((VoxelShape)top, (VoxelShape)Shapes.m_83113_((VoxelShape)xBottom, (VoxelShape)eastMiddle, (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_);
    }
}

