/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.crafting.recipe.BulletToDriveRecipe;
import vazkii.psi.common.item.ItemSpellBullet;
import vazkii.psi.common.item.ItemSpellDrive;
import vazkii.psi.common.item.base.ModItems;

public class BulletToDriveExtension
implements ICustomCraftingCategoryExtension {
    private final List<Ingredient> inputs;
    private final BulletToDriveRecipe recipe;

    public BulletToDriveExtension(BulletToDriveRecipe recipe) {
        this.recipe = recipe;
        Item[] bullets = (Item[])Registry.f_122827_.m_123024_().filter(item -> item instanceof ItemSpellBullet).toArray(Item[]::new);
        this.inputs = ImmutableList.of((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.spellDrive}), (Object)Ingredient.m_43929_((ItemLike[])bullets));
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputIngredients(this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModItems.spellDrive));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        ItemStack stack;
        recipeLayout.setShapeless();
        recipeLayout.getItemStacks().set(ingredients);
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focus != null && (stack = (ItemStack)focus.getValue()).m_41720_() instanceof ItemSpellBullet && ISpellAcceptor.hasSpell(stack)) {
            ItemStack drive = new ItemStack((ItemLike)ModItems.spellDrive);
            ItemSpellDrive.setSpell(drive, ISpellAcceptor.acceptor(stack).getSpell());
            recipeLayout.getItemStacks().set(0, drive);
            recipeLayout.getItemStacks().set(2, stack.m_41777_());
        }
    }

    public void drawInfo(int recipeWidth, int recipeHeight, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, I18n.m_118938_((String)"jei.psi.spell_copy", (Object[])new Object[0]), 57.0f, 46.0f, 0x808080);
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }
}

