/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.gui.GuiProgrammer;

public class GuiButtonSideConfig
extends Button {
    final GuiProgrammer gui;
    final int gridX;
    final int gridY;
    public final String paramName;
    final int paramIndex;
    final SpellParam.Side side;

    public GuiButtonSideConfig(GuiProgrammer gui, int gridX, int gridY, int paramIndex, String paramName, SpellParam.Side side, int x, int y) {
        super(x, y, 8, 8, TextComponent.f_131282_, Button::m_5691_);
        this.gui = gui;
        this.gridX = gridX;
        this.gridY = gridY;
        this.paramIndex = paramIndex;
        this.paramName = paramName;
        this.side = side;
    }

    public GuiButtonSideConfig(GuiProgrammer gui, int gridX, int gridY, int paramIndex, String paramName, SpellParam.Side side, int x, int y, Button.OnPress pressable) {
        super(x, y, 8, 8, TextComponent.f_131282_, pressable);
        this.gui = gui;
        this.gridX = gridX;
        this.gridY = gridY;
        this.paramIndex = paramIndex;
        this.paramName = paramName;
        this.side = side;
    }

    public void m_6303_(PoseStack ms, int par2, int par3, float pTicks) {
        if (this.f_93623_ && this.f_93624_ && !this.gui.takingScreenshot) {
            int minX = this.f_93620_;
            int minY = this.f_93621_;
            int maxX = minX + 8;
            int maxY = minY + 8;
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiProgrammer.texture);
            SpellPiece piece = this.gui.spell.grid.gridData[this.gridX][this.gridY];
            if (piece == null) {
                return;
            }
            SpellParam<?> param = piece.params.get(this.paramName);
            if (param == null) {
                return;
            }
            SpellParam.Side currSide = piece.paramSides.get(param);
            if (currSide == this.side) {
                RenderSystem.m_157429_((float)((float)PsiRenderHelper.r(param.color) / 255.0f), (float)((float)PsiRenderHelper.g(param.color) / 255.0f), (float)((float)PsiRenderHelper.b(param.color) / 255.0f), (float)1.0f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            float wh = 8.0f;
            float minU = (float)this.side.u / 256.0f;
            float minV = (float)this.side.v / 256.0f;
            float maxU = ((float)this.side.u + wh) / 256.0f;
            float maxV = ((float)this.side.v + wh) / 256.0f;
            BufferBuilder wr = Tesselator.m_85913_().m_85915_();
            wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            wr.m_5483_((double)minX, (double)maxY, 0.0).m_7421_(minU, maxV).m_5752_();
            wr.m_5483_((double)maxX, (double)maxY, 0.0).m_7421_(maxU, maxV).m_5752_();
            wr.m_5483_((double)maxX, (double)minY, 0.0).m_7421_(maxU, minV).m_5752_();
            wr.m_5483_((double)minX, (double)minY, 0.0).m_7421_(minU, minV).m_5752_();
            Tesselator.m_85913_().m_85914_();
        }
    }

    public boolean matches(int index, SpellParam.Side side) {
        return this.paramIndex == index && this.side == side;
    }

    public static void performAction(GuiProgrammer gui, int gridX, int gridY, String paramName, SpellParam.Side side) {
        SpellPiece piece = gui.spell.grid.gridData[gridX][gridY];
        if (piece == null) {
            return;
        }
        SpellParam<?> param = piece.params.get(paramName);
        if (param == null) {
            return;
        }
        piece.paramSides.put(param, side);
    }
}

