/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.gui.PsiHudElementType;
import vazkii.psi.api.gui.RenderPsiHudEvent;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.base.IHUDItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="psi")
public final class HUDHandler {
    private static final ResourceLocation psiBar = new ResourceLocation("psi:textures/gui/psi_bar.png");
    private static final ResourceLocation psiBarMask = new ResourceLocation("psi:textures/gui/psi_bar_mask.png");
    private static final ResourceLocation psiBarShatter = new ResourceLocation("psi:textures/gui/psi_bar_shatter.png");
    private static final int secondaryTextureUnit = 7;
    private static boolean registeredMask = false;
    private static final int maxRemainingTicks = 30;
    private static ItemStack remainingDisplayStack;
    private static int remainingTime;
    private static int remainingCount;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onDraw(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.LAYER) {
            Window resolution = event.getWindow();
            float partialTicks = event.getPartialTicks();
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.PSI_BAR))) {
                HUDHandler.drawPsiBar(event.getMatrixStack(), resolution, partialTicks);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.SOCKETABLE_EQUIPPED_NAME))) {
                HUDHandler.renderSocketableEquippedName(event.getMatrixStack(), resolution, partialTicks);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.REMAINING_ITEMS))) {
                HUDHandler.renderRemainingItems(event.getMatrixStack(), resolution, partialTicks);
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.HUD_ITEM))) {
                HUDHandler.renderHUDItem(event.getMatrixStack(), resolution, partialTicks);
            }
        }
    }

    public static void tick() {
        if (remainingTime > 0) {
            --remainingTime;
        }
    }

    private static boolean showsBar(PlayerDataHandler.PlayerData data, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.getCapability(PsiAPI.PSI_BAR_DISPLAY_CAPABILITY).map(c -> c.shouldShow(data)).orElse(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPsiBar(PoseStack ms, Window res, float pticks) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack cadStack = PsiAPI.getPlayerCAD((Player)mc.f_91074_);
        if (cadStack.m_41619_()) {
            return;
        }
        ICAD cad = (ICAD)cadStack.m_41720_();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)mc.f_91074_);
        int totalPsi = data.getTotalPsi();
        int currPsi = data.getAvailablePsi();
        if (((Boolean)ConfigHandler.CLIENT.contextSensitiveBar.get()).booleanValue() && currPsi == totalPsi && !HUDHandler.showsBar(data, mc.f_91074_.m_21205_()) && !HUDHandler.showsBar(data, mc.f_91074_.m_21206_())) {
            return;
        }
        ms.m_85836_();
        boolean right = (Boolean)ConfigHandler.CLIENT.psiBarOnRight.get();
        int pad = 3;
        int width = 32;
        int height = 140;
        int x = -pad;
        if (right) {
            x = res.m_85445_() + pad - width;
        }
        int y = res.m_85446_() / 2 - height / 2;
        if (!registeredMask) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)psiBarMask);
            RenderSystem.m_157456_((int)1, (ResourceLocation)psiBarShatter);
            registeredMask = true;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)psiBar);
        GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)64, (int)256);
        x += 8;
        y += 26;
        width = 16;
        height = 106;
        float r = 0.6f;
        float g = 0.65f;
        float b = 1.0f;
        int origHeight = height;
        int origY = y;
        int v = 0;
        int texture = 0;
        boolean shaders = ShaderHandler.useShaders;
        if (shaders) {
            RenderSystem.m_69388_((int)33991);
            texture = GL11.glGetInteger((int)32873);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        for (PlayerDataHandler.PlayerData.Deduction d : data.deductions) {
            float a = d.getPercentile(pticks);
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
            height = (int)Math.ceil((double)origHeight * (double)d.deduct / (double)totalPsi);
            int effHeight = (int)((double)origHeight * (double)d.current / (double)totalPsi);
            v = origHeight - effHeight;
            y = origY + v;
            ShaderHandler.useShader(ShaderHandler.psiBar, HUDHandler.generateCallback(a, d.shatter, data.overflowed));
            GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)32.0f, (float)v, (int)width, (int)height, (int)64, (int)256);
        }
        float textY = origY;
        if (totalPsi > 0) {
            height = (int)((double)origHeight * (double)data.availablePsi / (double)totalPsi);
            v = origHeight - height;
            y = origY + v;
            if (data.availablePsi != data.lastAvailablePsi) {
                float textHeight = (float)((double)origHeight * ((double)((float)data.availablePsi * pticks) + (double)data.lastAvailablePsi * (1.0 - (double)pticks)) / (double)totalPsi);
                textY = (float)origY + ((float)origHeight - textHeight);
            } else {
                textY = y;
            }
        } else {
            height = 0;
        }
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        ShaderHandler.useShader(ShaderHandler.psiBar, HUDHandler.generateCallback(1.0f, false, data.overflowed));
        GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)32.0f, (float)v, (int)width, (int)height, (int)64, (int)256);
        ShaderHandler.releaseShader();
        if (shaders) {
            RenderSystem.m_69388_((int)33991);
            RenderSystem.m_69396_((int)texture);
            RenderSystem.m_69388_((int)33984);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.m_85836_();
        ms.m_85837_(0.0, (double)textY, 0.0);
        width = 44;
        height = 3;
        int storedPsi = cad.getStoredPsi(cadStack);
        String s1 = storedPsi == -1 ? "\u221e" : "" + data.availablePsi;
        String s2 = "" + storedPsi;
        int offBar = 22;
        int offStr1 = 7 + mc.f_91062_.m_92895_(s1);
        int offStr2 = 7 + mc.f_91062_.m_92895_(s2);
        if (!right) {
            offBar = 6;
            offStr1 = -23;
            offStr2 = -23;
        }
        int color = cad.getSpellColor(cadStack);
        RenderSystem.m_157429_((float)((float)PsiRenderHelper.r(color) / 255.0f), (float)((float)PsiRenderHelper.g(color) / 255.0f), (float)((float)PsiRenderHelper.b(color) / 255.0f), (float)1.0f);
        GuiComponent.m_93133_((PoseStack)ms, (int)(x - offBar), (int)-2, (float)0.0f, (float)140.0f, (int)width, (int)height, (int)64, (int)256);
        mc.f_91062_.m_92750_(ms, s1, (float)(x - offStr1), -11.0f, 0xFFFFFF);
        ms.m_85849_();
        if (storedPsi != -1) {
            ms.m_85836_();
            ms.m_85837_(0.0, (double)Math.max(textY + 3.0f, (float)(origY + 100)), 0.0);
            mc.f_91062_.m_92750_(ms, s2, (float)(x - offStr2), 0.0f, 0xFFFFFF);
            ms.m_85849_();
        }
        RenderSystem.m_69461_();
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderSocketableEquippedName(PoseStack ms, Window res, float pticks) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (!ISocketable.isSocketable(stack)) {
            return;
        }
        String name = ISocketable.getSocketedItemName(stack, "").getString();
        if (stack.m_41619_() || name.trim().isEmpty()) {
            return;
        }
        int ticks = mc.f_91065_.f_92993_;
        if ((ticks -= 10) > 0) {
            ISocketable socketable = ISocketable.socketable(stack);
            ItemStack bullet = socketable.getSelectedBullet();
            int alpha = Math.min(255, (int)(((float)ticks - pticks) * 256.0f / 10.0f));
            int color = 1295871 + (alpha << 24);
            int x = res.m_85445_() / 2 - mc.f_91062_.m_92895_(name) / 2;
            int y = res.m_85446_() - 71;
            if (mc.f_91074_.m_7500_()) {
                y += 14;
            }
            mc.f_91062_.m_92750_(ms, name, (float)x, (float)y, color);
            int w = mc.f_91062_.m_92895_(name);
            ms.m_85836_();
            ms.m_85837_((double)(x + w), (double)(y - 6), 0.0);
            ms.m_85841_((float)alpha / 255.0f, 1.0f, 1.0f);
            PsiRenderHelper.transferMsToGl(ms, () -> mc.m_91291_().m_115123_(bullet, 0, 0));
            ms.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderRemainingItems(PoseStack ms, Window resolution, float partTicks) {
        if (remainingTime > 0 && !remainingDisplayStack.m_41619_()) {
            int pos = 30 - remainingTime;
            Minecraft mc = Minecraft.m_91087_();
            int remainingLeaveTicks = 20;
            int x = resolution.m_85445_() / 2 + 10 + Math.max(0, pos - remainingLeaveTicks);
            int y = resolution.m_85446_() / 2;
            int start = 30 - remainingLeaveTicks;
            float alpha = (float)remainingTime + partTicks > (float)start ? 1.0f : ((float)remainingTime + partTicks) / (float)start;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int xp = x + (int)(16.0f * (1.0f - alpha));
            ms.m_85836_();
            ms.m_85837_((double)xp, (double)y, 0.0);
            ms.m_85841_(alpha, 1.0f, 1.0f);
            PsiRenderHelper.transferMsToGl(ms, () -> mc.m_91291_().m_115203_(remainingDisplayStack, 0, 0));
            ms.m_85841_(1.0f / alpha, 1.0f, 1.0f);
            ms.m_85837_((double)(-xp), (double)(-y), 0.0);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Object text = remainingDisplayStack.m_41786_().m_6879_().m_130940_(ChatFormatting.GREEN).getString();
            if (remainingCount >= 0) {
                int max = remainingDisplayStack.m_41741_();
                int stacks = remainingCount / max;
                int rem = remainingCount % max;
                text = stacks == 0 ? "" + remainingCount : remainingCount + " (" + ChatFormatting.AQUA + stacks + ChatFormatting.RESET + "*" + ChatFormatting.GRAY + max + ChatFormatting.RESET + "+" + ChatFormatting.YELLOW + rem + ChatFormatting.RESET + ")";
            } else if (remainingCount == -1) {
                text = "\u221e";
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            mc.f_91062_.m_92750_(ms, (String)text, (float)(x + 20), (float)(y + 6), color);
            ms.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderHUDItem(PoseStack ms, Window resolution, float partTicks) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = mc.f_91074_.m_21205_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof IHUDItem) {
            ((IHUDItem)stack.m_41720_()).drawHUD(ms, resolution, partTicks, stack);
        }
        if (!(stack = mc.f_91074_.m_21206_()).m_41619_() && stack.m_41720_() instanceof IHUDItem) {
            ((IHUDItem)stack.m_41720_()).drawHUD(ms, resolution, partTicks, stack);
        }
    }

    public static void setRemaining(ItemStack stack, int count) {
        remainingDisplayStack = stack;
        remainingCount = count;
        remainingTime = stack.m_41619_() ? 0 : 30;
    }

    public static void setRemaining(Player player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !(pattern == null ? ItemStack.m_41746_((ItemStack)displayStack, (ItemStack)stack) : pattern.matcher(stack.m_41778_()).find())) continue;
            count += stack.m_41613_();
        }
        HUDHandler.setRemaining(displayStack, count);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Consumer<Integer> generateCallback(float percentile, boolean shatter, boolean overflowed) {
        Minecraft mc = Minecraft.m_91087_();
        return shader -> {
            int percentileUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"percentile");
            int overflowedUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"overflowed");
            int imageUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"image");
            int maskUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"mask");
            RenderSystem.m_69388_((int)33984);
            RenderSystem.m_157456_((int)0, (ResourceLocation)psiBar);
            ARBShaderObjects.glUniform1iARB((int)imageUniform, (int)0);
            RenderSystem.m_69388_((int)33991);
            RenderSystem.m_69493_();
            RenderSystem.m_157456_((int)1, (ResourceLocation)(shatter ? psiBarShatter : psiBarMask));
            ARBShaderObjects.glUniform1iARB((int)maskUniform, (int)7);
            ARBShaderObjects.glUniform1fARB((int)percentileUniform, (float)percentile);
            ARBShaderObjects.glUniform1iARB((int)overflowedUniform, (int)(overflowed ? 1 : 0));
        };
    }
}

