/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;

public class EntityListWrapper
implements Iterable<Entity> {
    private final List<Entity> list;
    public static final EntityListWrapper EMPTY = new EntityListWrapper(Collections.emptyList());

    private EntityListWrapper(@Nonnull List<Entity> list) {
        this.list = Objects.requireNonNull(list);
    }

    public static EntityListWrapper make(@Nonnull List<Entity> list) {
        ArrayList<Entity> copy = new ArrayList<Entity>();
        for (Entity e : list) {
            if (e == null) continue;
            copy.add(e);
        }
        copy.sort(EntityListWrapper::compareEntities);
        return new EntityListWrapper(copy);
    }

    public static EntityListWrapper union(@Nonnull EntityListWrapper left, @Nonnull EntityListWrapper right) {
        List<Entity> l1 = left.list;
        List<Entity> l2 = right.list;
        ArrayList<Entity> entities = new ArrayList<Entity>(l1.size() + l2.size());
        int i = 0;
        int j = 0;
        while (i < l1.size() && j < l2.size()) {
            int cmp = EntityListWrapper.compareEntities(l1.get(i), l2.get(j));
            if (cmp == 0) {
                ++i;
                continue;
            }
            entities.add(cmp < 0 ? l1.get(i++) : l2.get(j++));
        }
        entities.addAll(l1.subList(i, l1.size()));
        entities.addAll(l2.subList(j, l2.size()));
        return new EntityListWrapper(entities);
    }

    public static EntityListWrapper exclusion(@Nonnull EntityListWrapper list, @Nonnull EntityListWrapper remove) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        List<Entity> search = remove.list;
        for (Entity e : list) {
            if (Collections.binarySearch(search, e, EntityListWrapper::compareEntities) >= 0) continue;
            result.add(e);
        }
        return new EntityListWrapper(result);
    }

    public static EntityListWrapper intersection(@Nonnull EntityListWrapper left, @Nonnull EntityListWrapper right) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        List<Entity> search = right.list;
        for (Entity e : left) {
            if (Collections.binarySearch(search, e, EntityListWrapper::compareEntities) < 0) continue;
            result.add(e);
        }
        return new EntityListWrapper(result);
    }

    public static EntityListWrapper withAdded(@Nonnull EntityListWrapper base, @Nonnull Entity toAdd) {
        ArrayList<Entity> list = new ArrayList<Entity>(base.list);
        int index = Collections.binarySearch(list, toAdd, EntityListWrapper::compareEntities);
        if (index < 0) {
            list.add(~index, toAdd);
        }
        return new EntityListWrapper(list);
    }

    public static EntityListWrapper withRemoved(@Nonnull EntityListWrapper base, @Nonnull Entity toRemove) {
        ArrayList<Entity> list = new ArrayList<Entity>(base.list);
        list.remove(toRemove);
        return new EntityListWrapper(list);
    }

    public static int compareEntities(Entity l, Entity r) {
        return l.m_142081_().compareTo(r.m_142081_());
    }

    @Deprecated
    private List<Entity> unwrap() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public Entity get(int index) {
        return this.list.get(index);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    @Nonnull
    public Iterator<Entity> iterator() {
        return this.list.iterator();
    }
}

