/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;

public interface ISpellAcceptor {
    public static boolean isAcceptor(ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).isPresent();
    }

    public static boolean isContainer(ItemStack stack) {
        return stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).map(ISpellAcceptor::castableFromSocket).orElse(false);
    }

    public static boolean hasSpell(ItemStack stack) {
        return stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).map(ISpellAcceptor::containsSpell).orElse(false);
    }

    public static ISpellAcceptor acceptor(ItemStack stack) {
        return (ISpellAcceptor)stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public void setSpell(Player var1, Spell var2);

    default public boolean castableFromSocket() {
        return false;
    }

    @Nullable
    default public Spell getSpell() {
        return null;
    }

    default public boolean containsSpell() {
        return false;
    }

    default public ArrayList<Entity> castSpell(SpellContext context) {
        return null;
    }

    default public boolean loopcastSpell(SpellContext context) {
        this.castSpell(context);
        return false;
    }

    default public double getCostModifier() {
        return 1.0;
    }

    default public boolean isCADOnlyContainer() {
        return false;
    }

    default public boolean requiresSneakForSpellSet() {
        return false;
    }
}

