/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.cad;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.spell.ISpellAcceptor;

public interface ISocketable {
    public static final List<ResourceLocation> signs = Arrays.asList(new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 0)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 1)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 2)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 3)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 4)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 5)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 6)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 7)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 8)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 9)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 10)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 11)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 12)));
    public static final int MAX_ASSEMBLER_SLOTS = 12;

    public static Component getSocketedItemName(ItemStack stack, String fallbackKey) {
        if (stack.m_41619_() || !ISocketable.isSocketable(stack)) {
            return new TranslatableComponent(fallbackKey);
        }
        ISocketable socketable = ISocketable.socketable(stack);
        ItemStack item = socketable.getSelectedBullet();
        if (item.m_41619_()) {
            return new TranslatableComponent(fallbackKey);
        }
        return item.m_41786_();
    }

    public static boolean isSocketable(ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).isPresent();
    }

    public static ISocketable socketable(ItemStack stack) {
        return (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElseThrow(NullPointerException::new);
    }

    public boolean isSocketSlotAvailable(int var1);

    default public List<Integer> getRadialMenuSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 12; ++i) {
            if (!this.isSocketSlotAvailable(i)) continue;
            list.add(i);
        }
        return list;
    }

    default public List<ResourceLocation> getRadialMenuIcons() {
        return signs;
    }

    public ItemStack getBulletInSocket(int var1);

    public void setBulletInSocket(int var1, ItemStack var2);

    public int getSelectedSlot();

    public void setSelectedSlot(int var1);

    default public int getLastSlot() {
        int slot = 0;
        while (this.isSocketSlotAvailable(slot + 1)) {
            ++slot;
        }
        return slot;
    }

    default public ItemStack getSelectedBullet() {
        return this.getBulletInSocket(this.getSelectedSlot());
    }

    default public boolean isItemValid(int slot, ItemStack bullet) {
        if (!this.isSocketSlotAvailable(slot)) {
            return false;
        }
        if (!ISpellAcceptor.isContainer(bullet)) {
            return false;
        }
        ISpellAcceptor container = ISpellAcceptor.acceptor(bullet);
        return this instanceof ICADData || !container.isCADOnlyContainer();
    }

    default public boolean canLoopcast() {
        return this instanceof ICADData;
    }
}

