/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.world.BlockEvent;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.ConfigHandler;

public class PieceTrickBreakBlock
extends PieceTrick {
    public static ThreadLocal<Boolean> doingHarvestCheck = ThreadLocal.withInitial(() -> false);
    SpellParam<Vector3> position;
    private static final List<List<ItemStack>> HARVEST_TOOLS_BY_LEVEL = List.of(PieceTrickBreakBlock.stacks(Items.f_42422_, Items.f_42423_, Items.f_42424_, Items.f_42421_), PieceTrickBreakBlock.stacks(Items.f_42427_, Items.f_42428_, Items.f_42429_, Items.f_42426_), PieceTrickBreakBlock.stacks(Items.f_42385_, Items.f_42386_, Items.f_42387_, Items.f_42384_), PieceTrickBreakBlock.stacks(Items.f_42390_, Items.f_42391_, Items.f_42392_, Items.f_42389_), PieceTrickBreakBlock.stacks(Items.f_42395_, Items.f_42396_, Items.f_42397_, Items.f_42394_));

    public PieceTrickBreakBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(20.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(50.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 50);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickBreakBlock.removeBlockWithDrops(context, context.caster, context.focalPoint.m_20193_(), tool, pos, v -> tool.m_41735_(v) || PieceTrickBreakBlock.canHarvest((Integer)ConfigHandler.COMMON.cadHarvestLevel.get(), v));
        return null;
    }

    public static void removeBlockWithDrops(SpellContext context, Player player, Level world, ItemStack stack, BlockPos pos, Predicate<BlockState> filter) {
        boolean unminable;
        if (stack.m_41619_()) {
            stack = PsiAPI.getPlayerCAD(player);
        }
        if (!world.m_46805_(pos)) {
            return;
        }
        BlockState blockstate = world.m_8055_(pos);
        boolean bl = unminable = blockstate.m_60800_((BlockGetter)world, pos) == -1.0f;
        if (!world.f_46443_ && !unminable && filter.test(blockstate) && !blockstate.m_60795_()) {
            ItemStack save = player.m_21205_();
            boolean wasChecking = doingHarvestCheck.get();
            doingHarvestCheck.set(true);
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundLevelEventPacket(2001, pos, Block.m_49956_((BlockState)blockstate), false));
            ((ServerPlayer)player).f_8941_.m_9280_(pos);
            doingHarvestCheck.set(wasChecking);
            player.m_21008_(InteractionHand.MAIN_HAND, save);
        }
    }

    public static BlockEvent.BreakEvent createBreakEvent(BlockState state, Player player, Level world, BlockPos pos, ItemStack tool) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (state == null || !PieceTrickBreakBlock.canHarvestBlock(state, player, world, pos, tool)) {
            event.setExpToDrop(0);
        } else {
            int bonusLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
            int silklevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool);
            event.setExpToDrop(state.getExpDrop((LevelReader)world, pos, bonusLevel, silklevel));
        }
        return event;
    }

    public static boolean canHarvestBlock(BlockState state, Player player, Level world, BlockPos pos, ItemStack stack) {
        boolean wasChecking = doingHarvestCheck.get();
        doingHarvestCheck.set(true);
        ItemStack oldHeldStack = player.m_21205_();
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)stack);
        boolean canHarvest = state.canHarvestBlock((BlockGetter)world, pos, player);
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)oldHeldStack);
        doingHarvestCheck.set(wasChecking);
        return canHarvest;
    }

    private static List<ItemStack> stacks(Item ... items) {
        return Stream.of(items).map(ItemStack::new).toList();
    }

    public static boolean canHarvest(int harvestLevel, BlockState state) {
        return !PieceTrickBreakBlock.getTool(harvestLevel, state).m_41619_();
    }

    public static ItemStack getHarvestToolStack(int harvestLevel, BlockState state) {
        return PieceTrickBreakBlock.getTool(harvestLevel, state).m_41777_();
    }

    private static ItemStack getTool(int harvestLevel, BlockState state) {
        if (!state.m_60834_()) {
            return HARVEST_TOOLS_BY_LEVEL.get(0).get(0);
        }
        int idx = Math.min(harvestLevel, HARVEST_TOOLS_BY_LEVEL.size() - 1);
        for (ItemStack tool : HARVEST_TOOLS_BY_LEVEL.get(idx)) {
            if (!tool.m_41735_(state)) continue;
            return tool;
        }
        return ItemStack.f_41583_;
    }

    public static int getHarvestLevel(BlockState state) {
        if (Items.f_41852_.m_8096_(state)) {
            return 0;
        }
        for (int i = 0; i < HARVEST_TOOLS_BY_LEVEL.size(); ++i) {
            for (ItemStack tool : HARVEST_TOOLS_BY_LEVEL.get(i)) {
                if (!tool.m_41735_(state)) continue;
                return i + 1;
            }
        }
        return HARVEST_TOOLS_BY_LEVEL.size() + 1;
    }
}

