/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class MessageLoopcastSync {
    private final int entityId;
    private final byte loopcastState;

    public MessageLoopcastSync(int entityId, boolean isLoopcasting, InteractionHand hand) {
        this.entityId = entityId;
        this.loopcastState = (byte)((isLoopcasting ? 1 : 0) | (hand == null ? 0 : hand.ordinal() << 1));
    }

    public MessageLoopcastSync(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.loopcastState = buf.readByte();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.writeByte((int)this.loopcastState);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        boolean isLoopcasting;
        boolean bl = isLoopcasting = (this.loopcastState & 1) != 0;
        InteractionHand loopcastHand = isLoopcasting ? ((this.loopcastState & 2) != 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND) : null;
        context.get().enqueueWork(() -> {
            Player mcPlayer = Psi.proxy.getClientPlayer();
            if (mcPlayer == null) {
                return;
            }
            Level world = mcPlayer.f_19853_;
            Entity player = null;
            if (world != null) {
                player = world.m_6815_(this.entityId);
            } else if (mcPlayer.m_142049_() == this.entityId) {
                player = mcPlayer;
            }
            if (player instanceof Player) {
                PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)player);
                data.loopcasting = isLoopcasting;
                data.loopcastHand = loopcastHand;
            }
        });
        return true;
    }
}

