/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.client.model.ArmorModels;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.tool.IPsimetalTool;
import vazkii.psi.common.item.tool.ToolSocketable;

public class ItemPsimetalArmor
extends ArmorItem
implements IPsimetalTool,
IPsiEventArmor {
    public final EquipmentSlot type;
    private static final String TAG_TIMES_CAST = "timesCast";

    public ItemPsimetalArmor(EquipmentSlot type, Item.Properties props) {
        this(type, PsiAPI.PSIMETAL_ARMOR_MATERIAL, props);
    }

    public ItemPsimetalArmor(EquipmentSlot type, ArmorMaterial mat, Item.Properties props) {
        super(mat, type, props);
        this.type = type;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.m_41776_()) {
            damage = stack.m_41773_();
        }
        super.setDamage(stack, damage);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)Attributes.f_22284_);
            modifiers.removeAll((Object)Attributes.f_22285_);
        }
        return modifiers;
    }

    @Nonnull
    public String m_5671_(ItemStack stack) {
        Object name = super.m_5671_(stack);
        if (!this.isEnabled(stack)) {
            name = (String)name + ".broken";
        }
        return name;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn);
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ArmorSocketable(stack, 3);
    }

    public void cast(ItemStack stack, PsiArmorEvent event) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(event.getPlayer());
        ItemStack playerCad = PsiAPI.getPlayerCAD(event.getPlayer());
        if (this.isEnabled(stack) && !playerCad.m_41619_()) {
            int timesCast = stack.m_41784_().m_128451_(TAG_TIMES_CAST);
            ItemStack bullet = ISocketable.socketable(stack).getSelectedBullet();
            ItemCAD.cast(event.getPlayer().m_20193_(), event.getPlayer(), data, bullet, playerCad, this.getCastCooldown(stack), 0, this.getCastVolume(), context -> {
                context.tool = stack;
                context.attackingEntity = event.attacker;
                context.damageTaken = event.damage;
                context.loopcastIndex = timesCast;
            }, (int)((double)data.calculateDamageDeduction((float)event.damage) * 0.75));
            stack.m_41784_().m_128405_(TAG_TIMES_CAST, timesCast + 1);
        }
    }

    @Override
    public void onEvent(ItemStack stack, PsiArmorEvent event) {
        if (event.type.equals(this.getTrueEvent(stack)) && event.getPlayer() != null) {
            this.cast(stack, event);
        }
    }

    public String getEvent(ItemStack stack) {
        return "psi.event.none";
    }

    public String getTrueEvent(ItemStack stack) {
        return stack.m_41784_().m_128461_("PsiEvent").isEmpty() ? this.getEvent(stack) : stack.m_41784_().m_128461_("PsiEvent");
    }

    public int getCastCooldown(ItemStack stack) {
        return 5;
    }

    public float getCastVolume() {
        return 0.025f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            Component componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
            tooltip.add((Component)new TranslatableComponent("psimisc.spell_selected", new Object[]{componentName}));
            tooltip.add((Component)new TranslatableComponent(this.getTrueEvent(stack)));
        });
    }

    public boolean isRepairable(ItemStack stack) {
        return super.isRepairable(stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "psi:textures/model/psimetal_exosuit.png";
    }

    public boolean hasCustomColor(@Nonnull ItemStack stack) {
        return true;
    }

    public int getColor(@Nonnull ItemStack stack) {
        return 1295871;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> defaultModel) {
                return ArmorModels.get(itemStack);
            }
        });
    }

    public static class ArmorSocketable
    extends ToolSocketable {
        public ArmorSocketable(ItemStack tool, int slots) {
            super(tool, slots);
        }

        @Override
        public void setSelectedSlot(int slot) {
            super.setSelectedSlot(slot);
            this.tool.m_41784_().m_128405_(ItemPsimetalArmor.TAG_TIMES_CAST, 0);
        }

        @Override
        public void setBulletInSocket(int slot, ItemStack bullet) {
            super.setBulletInSocket(slot, bullet);
            this.tool.m_41784_().m_128405_(ItemPsimetalArmor.TAG_TIMES_CAST, 0);
        }
    }
}

