/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.item.ItemSpellDrive;

public class BulletToDriveRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<BulletToDriveRecipe> SERIALIZER = new SimpleRecipeSerializer(BulletToDriveRecipe::new);

    public BulletToDriveRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundSource = false;
        boolean foundTarget = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ISpellAcceptor.hasSpell(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.m_41720_() instanceof ItemSpellDrive && ItemSpellDrive.getSpell(stack) == null) {
                if (foundSource) {
                    return false;
                }
                foundSource = true;
                continue;
            }
            return false;
        }
        return foundSource && foundTarget;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        Spell source = null;
        ItemStack target = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ISpellAcceptor.hasSpell(stack)) {
                source = ISpellAcceptor.acceptor(stack).getSpell();
                continue;
            }
            target = stack;
        }
        ItemStack copy = target.m_41777_();
        ItemSpellDrive.setSpell(copy, source);
        return copy;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!ISpellAcceptor.hasSpell(item)) continue;
            list.set(i, (Object)item.m_41777_());
            break;
        }
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public boolean m_5598_() {
        return true;
    }
}

