/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageChangeControllerSlot;
import vazkii.psi.common.network.message.MessageChangeSocketableSlot;

public class GuiSocketSelect
extends Screen {
    int timeIn = 0;
    int slotSelected = -1;
    ItemStack controllerStack;
    ISocketableController controller;
    ItemStack[] controlledStacks;
    int controlSlot;
    ItemStack socketableStack;
    ISocketable socketable;
    List<Integer> slots;
    List<ResourceLocation> signs;
    final Minecraft mc = Minecraft.m_91087_();

    public GuiSocketSelect(ItemStack stack) {
        super((Component)new TextComponent(""));
        this.controllerStack = ItemStack.f_41583_;
        this.socketableStack = ItemStack.f_41583_;
        if (ISocketable.isSocketable(stack)) {
            this.setSocketable(stack);
        } else if (stack.m_41720_() instanceof ISocketableController) {
            this.controllerStack = stack;
            this.controller = (ISocketableController)stack.m_41720_();
            this.controlledStacks = this.controller.getControlledStacks((Player)this.mc.f_91074_, stack);
            this.controlSlot = this.controller.getDefaultControlSlot(this.controllerStack);
            if (this.controlSlot >= this.controlledStacks.length) {
                this.controlSlot = 0;
            }
            this.setSocketable(this.controlledStacks.length == 0 ? ItemStack.f_41583_ : this.controlledStacks[this.controlSlot]);
        }
    }

    public void setSocketable(ItemStack stack) {
        if (stack.m_41619_()) {
            this.slots = new ArrayList<Integer>();
            return;
        }
        this.socketableStack = stack;
        this.socketable = ISocketable.socketable(stack);
        this.slots = this.socketable.getRadialMenuSlots();
        this.signs = this.socketable.getRadialMenuIcons();
    }

    public void m_6305_(PoseStack ms, int mx, int my, float partialTicks) {
        float radius;
        boolean mouseInSector;
        int seg;
        super.m_6305_(ms, mx, my, partialTicks);
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int maxRadius = 80;
        double angle = GuiSocketSelect.mouseAngle(x, y, mx, my);
        int segments = this.slots.size();
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)segments;
        ItemStack cadStack = PsiAPI.getPlayerCAD((Player)Minecraft.m_91087_().f_91074_);
        this.slotSelected = -1;
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buf = tess.m_85915_();
        RenderSystem.m_69464_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        for (seg = 0; seg < segments; ++seg) {
            mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || seg == this.socketable.getSelectedSlot()) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (seg % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (seg == 0) {
                buf.m_5483_((double)x, (double)y, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
            if (mouseInSector) {
                this.slotSelected = seg;
                if (!cadStack.m_41619_()) {
                    int color = Psi.proxy.getColorForCAD(cadStack);
                    r = PsiRenderHelper.r(color);
                    g = PsiRenderHelper.g(color);
                    b = PsiRenderHelper.b(color);
                } else {
                    b = 255;
                    g = 255;
                    r = 255;
                }
            } else if (seg == this.socketable.getSelectedSlot()) {
                if (!cadStack.m_41619_()) {
                    int color = Psi.proxy.getColorForCAD(cadStack);
                    r = 255 - PsiRenderHelper.r(color);
                    g = 255 - PsiRenderHelper.g(color);
                    b = 255 - PsiRenderHelper.b(color);
                } else {
                    r = 0;
                    g = 255;
                    b = 0;
                }
            }
            for (float i = 0.0f; i < degPer + step / 2.0f; i += step) {
                float rad = i + (float)seg * degPer;
                float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                if (i == 0.0f) {
                    buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
                }
                buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
            }
        }
        tess.m_85914_();
        RenderSystem.m_69493_();
        for (seg = 0; seg < segments; ++seg) {
            mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || seg == this.socketable.getSelectedSlot()) {
                radius *= 1.025f;
            }
            float rad = ((float)seg + 0.5f) * degPer;
            float xp = (float)x + Mth.m_14089_((float)rad) * radius;
            float yp = (float)y + Mth.m_14031_((float)rad) * radius;
            ItemStack stack = this.socketable.getBulletInSocket(seg);
            if (stack.m_41619_()) continue;
            float xsp = xp - 4.0f;
            float ysp = yp;
            String name = (mouseInSector ? ChatFormatting.UNDERLINE : ChatFormatting.RESET) + stack.m_41786_().getString();
            int width = this.f_96547_.m_92895_(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            this.mc.m_91291_().m_115123_(stack, xdp - 8, ydp - 8);
            if (xsp < (float)x) {
                xsp -= (float)(width - 8);
            }
            if (ysp < (float)y) {
                ysp -= 9.0f;
            }
            this.f_96547_.m_92750_(ms, name, xsp, ysp, 0xFFFFFF);
            if (seg == this.socketable.getSelectedSlot()) {
                int color = 65280;
                if (!cadStack.m_41619_()) {
                    color = 0xFF0000 - Psi.proxy.getColorForCAD(cadStack);
                }
                String string = I18n.m_118938_((String)"psimisc.selected", (Object[])new Object[0]);
                float f = xsp + (float)(width / 4);
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92750_(ms, string, f, ysp + 9.0f, color);
            }
            mod = 0.8;
            xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.signs.get(seg));
            GuiSocketSelect.m_93133_((PoseStack)ms, (int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        float shift = Math.min(5.0f, (float)this.timeIn + partialTicks) / 5.0f;
        float scale = 3.0f * shift;
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        if (this.controlledStacks != null && this.controlledStacks.length > 0) {
            int xs = this.f_96543_ / 2 - 18 * this.controlledStacks.length / 2 + 1;
            int ys = this.f_96544_ / 2;
            for (int i = 0; i < this.controlledStacks.length; ++i) {
                float yoff = 20.0f + (float)maxRadius;
                if (i == this.controlSlot) {
                    yoff += 5.0f;
                }
                ItemStack stack = this.controlledStacks[i];
                int rx = xs + i * 18;
                float ry = (float)ys + -yoff * shift;
                PsiRenderHelper.transferMsToGl(ms, () -> this.mc.m_91291_().m_115203_(stack, rx, (int)ry));
            }
        }
        if (!this.socketableStack.m_41619_()) {
            ms.m_85836_();
            ms.m_85841_(scale, scale, scale);
            PsiRenderHelper.transferMsToGl(ms, () -> this.mc.m_91291_().m_115203_(this.socketableStack, (int)((float)x / scale) - 8, (int)((float)y / scale) - 8));
            ms.m_85849_();
        }
        RenderSystem.m_69461_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        if (!this.controllerStack.m_41619_() && this.controlledStacks.length > 0) {
            if (mouseButton == 0) {
                ++this.controlSlot;
                if (this.controlSlot >= this.controlledStacks.length) {
                    this.controlSlot = 0;
                }
            } else if (mouseButton == 1) {
                --this.controlSlot;
                if (this.controlSlot < 0) {
                    this.controlSlot = this.controlledStacks.length - 1;
                }
            }
            this.setSocketable(this.controlledStacks[this.controlSlot]);
            return true;
        }
        return false;
    }

    public void m_96624_() {
        super.m_96624_();
        if (!this.isKeyDown(KeybindHandler.keybind)) {
            this.mc.m_91152_(null);
            if (this.slotSelected != -1) {
                int slot = this.slots.get(this.slotSelected);
                PlayerDataHandler.get((Player)this.mc.f_91074_).stopLoopcast();
                Object message = !this.controllerStack.m_41619_() ? new MessageChangeControllerSlot(this.controlSlot, slot) : new MessageChangeSocketableSlot(slot);
                MessageRegister.HANDLER.sendToServer(message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.mc.f_91066_.f_92085_, (Object)this.mc.f_91066_.f_92086_, (Object)this.mc.f_91066_.f_92087_, (Object)this.mc.f_91066_.f_92088_, (Object)this.mc.f_91066_.f_92090_, (Object)this.mc.f_91066_.f_92091_, (Object[])new KeyMapping[]{this.mc.f_91066_.f_92089_});
        for (KeyMapping k : set) {
            KeyMapping.m_90837_((InputConstants.Key)k.getKey(), (boolean)this.isKeyDown(k));
        }
        ++this.timeIn;
    }

    public boolean isKeyDown(KeyMapping keybind) {
        InputConstants.Key key = keybind.getKey();
        if (key.m_84868_() == InputConstants.Type.MOUSE) {
            return keybind.m_90857_();
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.m_84873_());
    }

    public boolean m_7043_() {
        return false;
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.m_14136_((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }
}

