/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.IErrorCatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageSpellError;

public class CompiledSpell {
    public final Spell sourceSpell;
    public final SpellMetadata metadata = new SpellMetadata();
    public final Stack<Action> actions = new Stack();
    public final Map<SpellPiece, CatchHandler> errorHandlers = new HashMap<SpellPiece, CatchHandler>();
    public final Map<SpellPiece, Action> actionMap = new HashMap<SpellPiece, Action>();
    public Action currentAction;
    public final boolean[][] spotsEvaluated;

    public CompiledSpell(Spell source) {
        this.sourceSpell = source;
        this.metadata.setStat(EnumSpellStat.BANDWIDTH, source.grid.getSize());
        this.spotsEvaluated = new boolean[9][9];
    }

    public boolean execute(SpellContext context) throws SpellRuntimeException {
        IPlayerData data = PsiAPI.internalHandler.getDataForPlayer(context.caster);
        while (!context.actions.isEmpty()) {
            Action a;
            this.currentAction = a = context.actions.pop();
            PsiAPI.internalHandler.setCrashData(this, a.piece);
            a.execute(data, context);
            PsiAPI.internalHandler.setCrashData(null, null);
            this.currentAction = null;
            if (context.stopped) {
                return false;
            }
            if (context.delay <= 0) continue;
            return true;
        }
        return false;
    }

    public void safeExecute(SpellContext context) {
        block5: {
            if (context.caster.m_20193_().f_46443_) {
                return;
            }
            try {
                if (context.actions == null) {
                    context.actions = (Stack)this.actions.clone();
                }
                if (context.cspell.execute(context)) {
                    PsiAPI.internalHandler.delayContext(context);
                }
            }
            catch (SpellRuntimeException e) {
                if (context.shouldSuppressErrors()) break block5;
                context.caster.m_6352_((Component)new TranslatableComponent(e.getMessage()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), Util.f_137441_);
                int x = context.cspell.currentAction.piece.x + 1;
                int y = context.cspell.currentAction.piece.y + 1;
                MessageSpellError message = new MessageSpellError("psi.spellerror.position", x, y);
                MessageRegister.sendToPlayer(message, context.caster);
            }
        }
    }

    public boolean hasEvaluated(int x, int y) {
        if (!SpellGrid.exists(x, y)) {
            return false;
        }
        return this.spotsEvaluated[x][y];
    }

    public class Action {
        public final SpellPiece piece;

        public Action(SpellPiece piece) {
            this.piece = piece;
        }

        public void execute(IPlayerData data, SpellContext context) throws SpellRuntimeException {
            try {
                data.markPieceExecuted(this.piece);
                Object o = this.piece.execute(context);
                Class<?> eval = this.piece.getEvaluationType();
                if (eval != null && eval != Void.class) {
                    context.evaluatedObjects[this.piece.x][this.piece.y] = o;
                }
            }
            catch (SpellRuntimeException exception) {
                if (CompiledSpell.this.errorHandlers.containsKey(this.piece)) {
                    if (!CompiledSpell.this.errorHandlers.get(this.piece).suppress(this.piece, context, exception)) {
                        throw exception;
                    }
                    return;
                }
                throw exception;
            }
        }
    }

    public class CatchHandler {
        public final SpellPiece handlerPiece;
        public final IErrorCatcher handler;

        public CatchHandler(SpellPiece handlerPiece) {
            this.handlerPiece = handlerPiece;
            this.handler = (IErrorCatcher)((Object)handlerPiece);
        }

        public boolean suppress(SpellPiece piece, SpellContext context, SpellRuntimeException exception) {
            Class<?> eval;
            boolean handled = this.handler.catchException(piece, context, exception);
            if (handled && (eval = piece.getEvaluationType()) != null && eval != Void.class) {
                context.evaluatedObjects[piece.x][piece.y] = this.handler.supplyReplacementValue(piece, context, exception);
            }
            return handled;
        }
    }
}

