/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class PieceTrickMoveBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> target;

    public PieceTrickMoveBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 10);
        meta.addStat(EnumSpellStat.COST, 15);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        ItemStack tool = context.getHarvestTool();
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 targetVal = this.getParamValue(context, this.target);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        World world = context.focalPoint.func_130014_f_();
        BlockPos pos = positionVal.toBlockPos();
        BlockState state = world.func_180495_p(pos);
        if (world.func_175625_s(pos) != null || state.func_185905_o() != PushReaction.NORMAL || state.func_185887_b((IBlockReader)world, pos) == -1.0f || !PieceTrickBreakBlock.canHarvestBlock(state, context.caster, world, pos, tool)) {
            return null;
        }
        BlockEvent.BreakEvent event = PieceTrickBreakBlock.createBreakEvent(state, context.caster, world, pos, tool);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        if (!targetVal.isAxial() || targetVal.isZero()) {
            return null;
        }
        Vector3 axis = targetVal.normalize();
        int x = pos.func_177958_n() + (int)axis.x;
        int y = pos.func_177956_o() + (int)axis.y;
        int z = pos.func_177952_p() + (int)axis.z;
        BlockPos pos1 = new BlockPos(x, y, z);
        BlockState state1 = world.func_180495_p(pos1);
        if (!world.func_175660_a(context.caster, pos) || !world.func_175660_a(context.caster, pos1)) {
            return null;
        }
        if (state1.isAir((IBlockReader)world, pos1) || state1.func_185904_a().func_76222_j()) {
            world.func_180501_a(pos1, state, 3);
            world.func_217377_a(pos, false);
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        return null;
    }
}

