/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.potion;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public abstract class PieceTrickPotionBase
extends PieceTrick {
    SpellParam<Entity> target;
    SpellParam<Number> power;
    SpellParam<Number> time;

    public PieceTrickPotionBase(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        if (this.hasPower()) {
            this.power = new ParamNumber("psi.spellparam.power", SpellParam.RED, false, true);
            this.addParam(this.power);
        }
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.BLUE, false, true);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double powerVal = 1.0;
        if (this.hasPower()) {
            powerVal = (Double)this.getParamEvaluation(this.power);
        }
        Double timeVal = (Double)this.getParamEvaluation(this.time);
        if (powerVal == null || timeVal == null || powerVal <= 0.0 || powerVal != (double)powerVal.intValue() || timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            throw new SpellCompilationException("psi.spellerror.nonpositiveinteger", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, 20 + this.getPotency(powerVal.intValue(), timeVal.intValue()));
        meta.addStat(EnumSpellStat.COST, 40 + this.getCost(powerVal.intValue(), timeVal.intValue()));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = this.getParamValue(context, this.target);
        context.verifyEntity(targetVal);
        if (!(targetVal instanceof LivingEntity)) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        if (!context.isInRadius(targetVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        double powerVal = 1.0;
        if (this.hasPower()) {
            powerVal = this.getParamValue(context, this.power).doubleValue();
        }
        double timeVal = this.getParamValue(context, this.time).doubleValue();
        ((LivingEntity)targetVal).func_195064_c(new EffectInstance(this.getPotion(), Math.max(1, (int)timeVal) * 20, this.hasPower() ? Math.max(0, (int)powerVal - 1) : 0));
        return null;
    }

    public abstract Effect getPotion();

    public int getCost(int power, int time) throws SpellCompilationException {
        return (int)this.multiplySafe(this.getPotency(power, time) * 5, new double[0]);
    }

    public int getPotency(int power, int time) throws SpellCompilationException {
        return (int)this.multiplySafe(time, power, power, 5.0);
    }

    public boolean hasPower() {
        return true;
    }
}

