/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;

public class ToolSocketable
implements ICapabilityProvider,
ISocketable,
IPsiBarDisplay,
ISpellAcceptor {
    protected final ItemStack tool;
    protected final int slots;
    private final LazyOptional<?> capOptional;

    public ToolSocketable(ItemStack tool, int slots) {
        this.tool = tool;
        this.slots = MathHelper.func_76125_a((int)slots, (int)1, (int)11);
        this.capOptional = LazyOptional.of(() -> this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PsiAPI.SOCKETABLE_CAPABILITY || cap == PsiAPI.PSI_BAR_DISPLAY_CAPABILITY || cap == PsiAPI.SPELL_ACCEPTOR_CAPABILITY) {
            return this.capOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.slots;
    }

    @Override
    public List<Integer> getRadialMenuSlots() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i <= this.slots; ++i) {
            list.add(i);
        }
        return list;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        String name = "bullet" + slot;
        CompoundNBT cmp = this.tool.func_196082_o().func_74775_l(name);
        if (cmp.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)cmp);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        String name = "bullet" + slot;
        CompoundNBT cmp = new CompoundNBT();
        if (!bullet.func_190926_b()) {
            cmp = bullet.func_77955_b(cmp);
        }
        this.tool.func_196082_o().func_218657_a(name, (INBT)cmp);
    }

    @Override
    public int getSelectedSlot() {
        return this.tool.func_196082_o().func_74762_e("selectedSlot");
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.tool.func_196082_o().func_74768_a("selectedSlot", slot);
    }

    @Override
    public boolean shouldShow(IPlayerData data) {
        return false;
    }

    @Override
    public void setSpell(PlayerEntity player, Spell spell) {
        int slot = this.getSelectedSlot();
        ItemStack bullet = this.getBulletInSocket(slot);
        if (!bullet.func_190926_b() && ISpellAcceptor.isAcceptor(bullet)) {
            ISpellAcceptor.acceptor(bullet).setSpell(player, spell);
            this.setBulletInSocket(slot, bullet);
        }
    }

    @Override
    public boolean castableFromSocket() {
        return false;
    }
}

