/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.spell.detonator.IDetonationHandler;

public class CapabilityTriggerSensor
implements IDetonationHandler,
ICapabilityProvider {
    public final PlayerEntity player;
    public static final String TRIGGER_TICK = "psi:LastTriggeredDetonation";

    public CapabilityTriggerSensor(PlayerEntity player) {
        this.player = player;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return PsiAPI.DETONATION_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this));
    }

    @Override
    public void detonate() {
        long worldTime;
        CompoundNBT playerData = this.player.getPersistentData();
        long detonated = playerData.func_74763_f(TRIGGER_TICK);
        if (detonated != (worldTime = this.player.field_70170_p.func_82737_E())) {
            playerData.func_74772_a(TRIGGER_TICK, worldTime);
            PsiArmorEvent.post(new PsiArmorEvent(this.player, "psi.event.spell_detonate"));
        }
    }

    @Override
    public Vector3d objectLocus() {
        return this.player.func_213303_ch();
    }
}

