/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.constant;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.common.Psi;

public class PieceConstantNumber
extends SpellPiece {
    private static final String TAG_CONSTANT_VALUE = "constantValue";
    public String valueStr;

    public PieceConstantNumber(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        super.initParams();
        this.valueStr = "0";
    }

    @Override
    public void drawAdditional(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        if (this.valueStr == null || this.valueStr.isEmpty() || this.valueStr.length() > 5) {
            this.valueStr = "0";
        }
        Minecraft mc = Minecraft.func_71410_x();
        int color = Psi.magical ? 0 : 0xFFFFFF;
        float efflen = mc.field_71466_p.func_78256_a(this.valueStr);
        float scale = 1.0f;
        while (efflen > 16.0f) {
            efflen = (float)mc.field_71466_p.func_78256_a(this.valueStr) / (scale += 1.0f);
        }
        ms.func_227860_a_();
        ms.func_227862_a_(1.0f / scale, 1.0f / scale, 1.0f);
        ms.func_227861_a_((double)((9.0f - efflen / 2.0f) * scale), (double)(4.0f * scale), 0.0);
        mc.field_71466_p.func_228079_a_(this.valueStr, 0.0f, 0.0f, color, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
        ms.func_227865_b_();
    }

    @Override
    public boolean interceptKeystrokes() {
        return true;
    }

    @Override
    public boolean onCharTyped(char character, int keyCode, boolean doit) {
        String newValueStr;
        if ("FDfd".indexOf(character) >= 0) {
            return false;
        }
        String oldStr = this.valueStr;
        String newStr = this.valueStr;
        if ((newStr.equals("0") || newStr.equals("-0")) && "+-.".indexOf(character) < 0) {
            newStr = newStr.replace("0", "");
        }
        if (character == '+') {
            newStr = newStr.replace("-", "");
        } else if (character == '-') {
            if (!newStr.startsWith("-")) {
                newStr = "-" + newStr;
            }
        } else {
            newStr = newStr + character;
        }
        if (newStr.isEmpty()) {
            newStr = "0";
        }
        if ((newStr = newStr.trim()).length() > 5) {
            return false;
        }
        try {
            Double.parseDouble(newStr);
            newValueStr = newStr;
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (doit) {
            this.valueStr = newValueStr;
        }
        return !newValueStr.equals(oldStr);
    }

    @Override
    public boolean onKeyPressed(int keyCode, int scanCode, boolean doit) {
        String newValueStr;
        String oldStr = this.valueStr;
        String newStr = this.valueStr;
        if (keyCode == 259) {
            if (newStr.length() == 2 && newStr.startsWith("-")) {
                newStr = "-0";
            } else if (newStr.equals("-")) {
                newStr = "0";
            } else if (!newStr.isEmpty()) {
                newStr = newStr.substring(0, newStr.length() - 1);
            }
        }
        if (newStr.isEmpty()) {
            newStr = "0";
        }
        if ((newStr = newStr.trim()).length() > 5) {
            return false;
        }
        try {
            Double.parseDouble(newStr);
            newValueStr = newStr;
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (doit) {
            this.valueStr = newValueStr;
        }
        return !newValueStr.equals(oldStr);
    }

    @Override
    public EnumPieceType getPieceType() {
        return EnumPieceType.CONSTANT;
    }

    @Override
    public void writeToNBT(CompoundNBT cmp) {
        super.writeToNBT(cmp);
        cmp.func_74778_a(TAG_CONSTANT_VALUE, this.valueStr);
    }

    @Override
    public void readFromNBT(CompoundNBT cmp) {
        super.readFromNBT(cmp);
        this.valueStr = cmp.func_74779_i(TAG_CONSTANT_VALUE);
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }

    @Override
    public Object evaluate() {
        if (this.valueStr == null || this.valueStr.isEmpty() || this.valueStr.length() > 5) {
            this.valueStr = "0";
        }
        try {
            return Double.parseDouble(this.valueStr);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public Object execute(SpellContext context) {
        return this.evaluate();
    }
}

