/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.psi.common.Psi;

public class MessageVisualEffect {
    public static final int TYPE_CRAFT = 0;
    private final int color;
    private final double x;
    private final double y;
    private final double z;
    private final double width;
    private final double height;
    private final double offset;
    private final int effectType;

    public MessageVisualEffect(int color, double x, double y, double z, double width, double height, double offset, int effectType) {
        this.color = color;
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.effectType = effectType;
    }

    public MessageVisualEffect(PacketBuffer buf) {
        this.color = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.width = buf.readDouble();
        this.height = buf.readDouble();
        this.offset = buf.readDouble();
        this.effectType = buf.func_150792_a();
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.color);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.width);
        buf.writeDouble(this.height);
        buf.writeDouble(this.offset);
        buf.func_150787_b(this.effectType);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        context.get().enqueueWork(() -> {
            World world = Psi.proxy.getClientWorld();
            switch (this.effectType) {
                case 0: {
                    for (int i = 0; i < 5; ++i) {
                        double particleX = this.x + (Math.random() - 0.5) * 2.1 * this.width;
                        double particleY = this.y - this.offset;
                        double particleZ = this.z + (Math.random() - 0.5) * 2.1 * this.width;
                        float grav = -0.05f - (float)Math.random() * 0.01f;
                        Psi.proxy.sparkleFX(particleX, particleY, particleZ, r, g, b, grav, 3.5f, 15);
                        double m = 0.01;
                        double d3 = 10.0;
                        for (int j = 0; j < 3; ++j) {
                            double d0 = world.field_73012_v.nextGaussian() * m;
                            double d1 = world.field_73012_v.nextGaussian() * m;
                            double d2 = world.field_73012_v.nextGaussian() * m;
                            world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x + (double)world.field_73012_v.nextFloat() * this.width * 2.0 - this.width - d0 * d3, this.y + (double)world.field_73012_v.nextFloat() * this.height - d1 * d3, this.z + (double)world.field_73012_v.nextFloat() * this.width * 2.0 - this.width - d2 * d3, d0, d1, d2);
                        }
                    }
                    break;
                }
            }
        });
        return true;
    }
}

