/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageAdditiveMotion;

@Mod.EventBusSubscriber(modid="psi")
public class AdditiveMotionHandler {
    private static final Map<Entity, Vector3d> toUpdate = new WeakHashMap<Entity, Vector3d>();

    public static void addMotion(Entity entity, double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            Vector3d base = toUpdate.getOrDefault(entity, Vector3d.field_186680_a);
            toUpdate.put(entity, base.func_72441_c(x, y, z));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.WorldTickEvent e) {
        if (e.side.isServer() && e.phase == TickEvent.Phase.END) {
            for (Entity entity : toUpdate.keySet()) {
                Vector3d vec;
                if (entity.field_70133_I || (vec = toUpdate.get(entity)) == null) continue;
                MessageAdditiveMotion motion = new MessageAdditiveMotion(entity.func_145782_y(), vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                if (entity instanceof ServerPlayerEntity) {
                    MessageRegister.sendToPlayer(motion, (PlayerEntity)((ServerPlayerEntity)entity));
                } else {
                    entity.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                if (!(entity.field_70170_p instanceof ServerWorld)) continue;
                MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)motion);
            }
            toUpdate.clear();
        }
    }
}

